@extends('master.back')

@section('content')

<div class="container-fluid">

<!-- Page Heading -->
<div class="card mb-4">
    <div class="card-body">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h3 class="mb-0 bc-title"><b>{{ __('Create Product') }}</b> </h3>
            <a class="btn btn-primary   btn-sm" href="{{route('back.item.index')}}"><i class="fas fa-chevron-left"></i> {{ __('Back') }}</a>
        </div>
    </div>
</div>

<!-- Form -->


<div class="row">
    <div class="col-lg-12">
            @include('alerts.alerts')
    </div>
</div>
<!-- Nested Row within Card Body -->
<form id="myForm" class="admin-form tab-form" action="{{ route('back.item.store') }}" method="POST"
                enctype="multipart/form-data">
                <input type="hidden" value="normal" name="item_type">
                @csrf
    <div class="row">

        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="name">{{ __('Name') }} *</label>
                        <input type="text" name="name" class="form-control item-name"
                            id="name" placeholder="{{ __('Enter Name') }}"
                            value="{{ old('name') }}" >
                    </div>
                    <div class="form-group">
                        <label for="slug">{{ __('Slug') }} *</label>
                        <input type="text" name="slug" class="form-control"
                            id="slug" placeholder="{{ __('Enter Slug') }}"
                            value="{{ old('slug') }}" >
                    </div>
                </div>
            </div>
           
            <div class="card">
                <div class="card-body">
                    <div class="form-group pb-0  mb-0">
                        <label class="d-block">{{ __('Featured Image') }} *</label>
                    </div>
                    <div class="form-group pb-0 pt-0 mt-0 mb-0">
                    <img class="admin-img lg" src="" >
                    </div>
                    <div class="form-group position-relative ">
                        <label class="file">
                            <input type="file"  accept="image/*"   class="upload-photo" name="photo"
                                id="file"  aria-label="File browser example">
                            <span
                                class="file-custom text-left">{{ __('Upload Image...') }}</span>
                        </label>
                        <br>
                        <span class="mt-1 text-info">{{ __('Image Size Should Be 800 x 800. or square size') }}</span>
                    </div>
                </div>
            </div>
            {{-- <div class="card">
                <div class="card-body">
                    <div class="form-group pb-0  mb-0">
                        <label>{{ __('Gallery Images') }} </label>
                    </div>
                    <div class="form-group pb-0 pt-0 mt-0 mb-0">
                        <div id="gallery-images" class="">
                            <div class="d-block gallery_image_view">
                            </div>
                        </div>
                    </div>
                    <div class="form-group position-relative ">
                        <label class="file">
                            <input type="file"  accept="image/*"  name="galleries[]" id="gallery_file" aria-label="File browser example" accept="image/*" multiple>
                            <span class="file-custom text-left">{{ __('Upload Image...') }}</span>
                        </label>
                        <br>
                        <span class="mt-1 text-info">{{ __('Image Size Should Be 800 x 800. or square size') }}</span>
                    </div>
                </div>
            </div> --}}
            <div class="card">
                <div class="card-body">
                    <div class="form-group pb-0  mb-0">
                        <label class="d-block">{{ __('Pre Order Image') }} </label>
                    </div>
                    <div class="form-group pb-0 pt-0 mt-0 mb-0">
                    <img class="admin-img lg" src="" >
                    </div>
                    <div class="form-group position-relative ">
                        <label class="file">
                            <input type="file"  accept="image/*"   class="upload-photo" name="pre_order_image"
                                id="file"  aria-label="File browser example">
                            <span
                                class="file-custom text-left">{{ __('Upload Image...') }}</span>
                        </label>
                        <br>
                        <span class="mt-1 text-info">{{ __('Image Size Should Be 200 x 200. or square size') }}</span>
                    </div>
                </div>
            </div>
             <!-- Gallery Data Inputs -->
             <div class="card">
                <div class="card-body">
                    <div class="form-group" style="padding:2%">
                        <label for="inputEmail1" class="col-md-2 control-label">Gallery Images</label>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="photo_gallery">Photo</label>
                                <input type="file" class="form-control" id="photo_gallery" 
                                name="gallery[photo_gallery][]">
                            </div>
                            <div class="col-md-2">
                                <label for="color">Color</label>
                                <input type="text" class="form-control" placeholder="Color" id="color" name="gallery[color][]">
                            </div>
                            <div class="col-md-2">
                                <label for="size">Size</label>
                                <input type="text" class="form-control" placeholder="Size" id="size" name="gallery[size][]">
                            </div>
                            <div class="col-md-2">
                                <label for="price">Price</label>
                                <input type="number" class="form-control" placeholder="Price" id="price" name="gallery[price][]">
                            </div>
                            <div class="col-md-2">
                                <label for="stock">Stock</label>
                                <input type="number" class="form-control" placeholder="Stock" id="stock" name="gallery[stock][]">
                            </div>
                            <div class="col-md-1">
                                <label></label>
                                <button type="button" class="btn btn-success" id="add_items">+ Add</button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputEmail1" class="col-md-2 control-label">Item</label>
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered table-hover" id="mytable">
                                <tr>
                                    <th>Photo</th>
                                    <th>Color</th>
                                    <th>Size</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Action</th>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        
            <!-- Hidden input to store gallery data as JSON -->
            {{-- <input type="hidden" name="gallery_data" id="gallery_data"> --}}
    
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="sort_details">{{ __('Short Description') }} *</label>
                        <textarea name="sort_details" id="sort_details"
                            class="form-control"
                            placeholder="{{ __('Short Description') }}"
                            >{{ old('sort_details') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="details">{{ __('Description') }} *</label>
                        <textarea name="details" id="details"
                            class="form-control text-editor"
                            rows="6"
                            placeholder="{{ __('Enter Description') }}"
                            >{{ old('details') }}</textarea>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group mb-2">
                        <label for="tags">{{ __('Product Tags') }}
                            </label>
                        <input type="text" name="tags" class="tags"
                            id="tags"
                            placeholder="{{ __('Tags') }}"
                            value="">
                    </div>
                    <div class="form-group">
                        <label class="switch-primary">
                            <input type="checkbox" class="switch switch-bootstrap status radio-check" name="is_specification" value="1" checked>
                            <span class="switch-body"></span>
                            <span class="switch-text">{{ __('Specifications') }}</span>
                        </label>
                    </div>
                    <div id="specifications-section">
                        <div class="d-flex">

                            <div class="flex-grow-1">
                                <div class="form-group">
                                    <input type="text" class="form-control"
                                        name="specification_name[]"
                                        placeholder="{{ __('Specification Name') }}" value="">
                                    </div>
                            </div>
                            <div class="flex-grow-1">
                                <div class="form-group">
                                    <input type="text" class="form-control"
                                        name="specification_description[]"
                                        placeholder="{{ __('Specification description') }}" value="">
                                    </div>
                            </div>
                            <div class="flex-btn">
                                <button type="button" class="btn btn-success add-specification" data-text="{{ __('Specification Name') }}" data-text1="{{ __('Specification Description') }}"> <i class="fa fa-plus"></i> </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="meta_keywords">{{ __('Meta Keywords') }}
                            </label>
                        <input type="text" name="meta_keywords" class="tags"
                            id="meta_keywords"
                            placeholder="{{ __('Enter Meta Keywords') }}"
                            value="">
                    </div>

                    <div class="form-group">
                        <label
                            for="meta_description">{{ __('Meta Description') }}
                            </label>
                        <textarea name="meta_description" id="meta_description"
                            class="form-control" rows="5"
                            placeholder="{{ __('Enter Meta Description') }}"
                        >{{ old('meta_description') }}</textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="discount_price">{{ __('Current Price') }}
                            *</label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span
                                    class="input-group-text">{{ PriceHelper::adminCurrency() }}</span>
                            </div>
                            <input type="text" id="discount_price"
                                name="discount_price" class="form-control"
                                placeholder="{{ __('Enter Current Price') }}"
                                min="1" step="0.1"
                                value="{{ old('discount_price') }}" >
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="previous_price">{{ __('Previous Price') }}
                            </label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span
                                    class="input-group-text">{{ $curr->sign }}</span>
                            </div>
                            <input type="text" id="previous_price"
                                name="previous_price" class="form-control"
                                placeholder="{{ __('Enter Previous Price') }}"
                                min="1" step="0.1"
                                value="{{ old('previous_price') }}" >
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">

                    <div class="form-group">
                        <label for="category_id">{{ __('Select Category') }} *</label>
                        <select name="category_id" id="category_id" data-href="{{route('back.get.subcategory')}}" class="form-control" >
                            <option value="" selected>{{__('Select One')}}</option>
                            @foreach(DB::table('categories')->whereStatus(1)->get() as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="subcategory_id">{{ __('Select Sub Category') }} </label>
                        <select name="subcategory_id" id="subcategory_id" data-href="{{route('back.get.childcategory')}}" class="form-control">
                            <option value="">{{__('Select One')}}</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="childcategory_id">{{ __('Select Child Category') }} </label>
                        <select name="childcategory_id" id="childcategory_id" class="form-control">
                            <option value="">{{__('Select One')}}</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="brand_id">{{ __('Select Brand') }} </label>
                        <select name="brand_id" id="brand_id" class="form-control" >
                            <option value="" selected>{{__('Select Brand')}}</option>
                            @foreach(DB::table('brands')->whereStatus(1)->get() as $brand)
                            <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="stock">{{ __('Total in stock') }}
                            *</label>
                        <div class="input-group mb-3">
                            <input type="number" id="stock"
                                name="stock" class="form-control"
                                placeholder="{{ __('Total in stock') }}" value="{{ old('stock') }}" >
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="tax_id">{{ __('Select Tax') }} *</label>
                        <select name="tax_id" id="tax_id" class="form-control">
                            @foreach(DB::table('taxes')->where('status', 1)->orderBy('id', 'desc')->get() as $tax)
                                <option value="{{ $tax->id }}">{{ $tax->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="sku">{{ __('SKU') }} *</label>
                        <input type="text" name="sku" class="form-control"
                            id="sku" placeholder="{{ __('Enter SKU') }}"
                            value="{{Str::random(10)}}" >
                    </div>
                    <div class="form-group">
                        <label for="video">{{ __('Video Link') }} </label>
                        <input type="text" name="video" class="form-control"
                            id="video" placeholder="{{ __('Enter Video Link') }}"
                            value="{{ old('video') }}">
                    </div>
                    <div class="form-group">
                        <label for="hangingTime">{{ __('Enter Hanging Time (Days)') }} </label>
                        <input type="number" name="hangingTime" class="form-control"
                            id="hangingTime" placeholder="{{ __('Enter Hanging Time') }}"
                            value="{{ old('hangingTime') }}">
                    </div>
                    <div class="form-group">
                        <label for="pre_order_active">{{ __('Pre-Order Product') }} </label>
                        <select class="form-control" name="pre_order_active" id="pre_order_active">
                            <option value="0">No</option>
                            <option value="">Yes</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <input type="hidden" class="check_button" name="is_button" value="0">
                    <button type="submit" class="btn btn-secondary mr-2">{{ __('Save') }}</button>
                    <button type="submit" class="btn btn-info save__edit">{{ __('Save & Edit') }}</button>
                </div>
            </div>
        </div>

    </div>
</form>


</div>

</div>
<script>
    let imageCounter = 1; 
    let imageIdCounter = 0;

    document.getElementById('gallery_file_0').addEventListener('change', handleImagePreview);

    function handleImagePreview(event) {
        let galleryPreview = document.getElementById('galleryPreview');
        let files = event.target.files;

        if (files) {
            Array.from(files).forEach(file => {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let imageWrapper = document.createElement('div');
                    imageWrapper.classList.add('image-wrapper');
                    imageWrapper.style.display = 'inline-block';
                    imageWrapper.style.position = 'relative';
                    imageWrapper.id = 'image_' + imageIdCounter; 

                    // Create the image element
                    let imgElement = document.createElement('img');
                    imgElement.src = e.target.result;
                    imgElement.style.maxWidth = '100px';
                    imgElement.style.margin = '5px';

                    // Create delete button
                    let deleteBtn = document.createElement('button');
                    deleteBtn.innerHTML = '×'; // Cross symbol for delete
                    deleteBtn.classList.add('delete-btn');
                    deleteBtn.style.position = 'absolute';
                    deleteBtn.style.top = '5px';
                    deleteBtn.style.right = '5px';
                    deleteBtn.style.background = 'red';
                    deleteBtn.style.color = 'white';
                    deleteBtn.style.border = 'none';
                    deleteBtn.style.borderRadius = '50%';
                    deleteBtn.style.width = '20px';
                    deleteBtn.style.height = '20px';
                    deleteBtn.style.cursor = 'pointer';

                    // Add event listener to delete the image on click
                    deleteBtn.addEventListener('click', function() {
                        galleryPreview.removeChild(imageWrapper);
                    });

                    // Append the image and delete button to the image wrapper
                    imageWrapper.appendChild(imgElement);
                    imageWrapper.appendChild(deleteBtn);

                    // Append the image wrapper to the gallery preview area
                    galleryPreview.appendChild(imageWrapper);

                    imageIdCounter++; 
                }
                reader.readAsDataURL(file);
            });
        }
    }
</script>
{{-- <script>
     $(document).ready(function () {
    //    var time,c_temp,f_m_r = null;
    var items_array = [];
    function nullmaking(){
            $("#product").val(null);
            $("#size").val(null);
            $("#brand").val(null);
            $("#total_ctnc").val(null);
        }
    $("#add_items").click(function(){
        console.log($("#product").val());
            items_array.push({"product":$("#product").val(),"size":$("#size").val(),"brand":$("#brand").val(),"total_ctnc":$("#total_ctnc").val(),"status":"stay"});
            $("#provided_item").val('');
            $("#provided_item").val(JSON.stringify(items_array));
            $.each( items_array, function( key, item ) {
                 console.log(item);
                if (item.status == "stay") {
                    if(items_array.length-1 == key){
                        $("table#mytable tr").last().before("<tr id='"+key+"'><td>"+item.product+"</td><td>"+item.size+"</td><td>"+item.brand+"</td><td>"+item.total_ctnc+"</td><td><button class='btn btn-danger delete_item' data-id='"+key+"'>Delete</button></td></tr>");
                    }
                }
            });
            $(".delete_item").click(function(){
                items_array[$(this).data("id")].status="delete";
                // console.log(product_array,$(this).data("id"));
                $("#provided_item").val('');
                $("#provided_item").val(JSON.stringify(items_array));
                $("#"+$(this).data("id")).remove();
            });
            nullmaking();
    });

    });
</script> --}}
<!-- Load jQuery (Required) -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.3/jquery.validate.min.js"></script>


<script>
    $(document).ready(function () {
        document.getElementById('add_items').addEventListener('click', function () {
            const photo = document.querySelector('input[name="gallery[photo_gallery][]"]').files[0];
            const color = document.querySelector('input[name="gallery[color][]"]').value;
            const size = document.querySelector('input[name="gallery[size][]"]').value;
            const price = document.querySelector('input[name="gallery[price][]"]').value;
            const stock = document.querySelector('input[name="gallery[stock][]"]').value;

            if (photo && color && size && price && stock) {
                // Add to the table
                const reader = new FileReader();
                reader.readAsDataURL(photo);
                reader.onload = function () {
                    const base64Photo = reader.result;
                    console.log(base64Photo);
                    const table = document.getElementById('mytable').getElementsByTagName('tbody')[0];
                    const row = table.insertRow();
                    row.innerHTML = `
                        <td><img src="${URL.createObjectURL(photo)}" width="50"><input type="hidden" name="gallery_photo[]" value="${base64Photo}"></td>
                        <td>${color} <input type="hidden" name="gallery_color[]" value="${color}"> </td>
                        <td>${size} <input type="hidden" name="gallery_size[]" value="${size}"></td>
                        <td>${price} <input type="hidden" name="gallery_price[]" value="${price}"></td>
                        <td>${stock} <input type="hidden" name="gallery_stock[]" value="${stock}"></td>
                        <td><button type="button" class="btn btn-danger btn-sm remove-item">Remove</button></td>
                    `;

                    // Update the hidden input with gallery data
                    // const galleryData = JSON.parse(document.getElementById('gallery_data').value || '[]');
                    // galleryData.push({
                    //     photo_gallery: photo.name, // Store the file name
                    //     color: color,
                    //     size: size,
                    //     price: price,
                    //     stock: stock,
                    // });
                    // document.getElementById('gallery_data').value = JSON.stringify(galleryData);

                    // Clear the form
                    document.querySelector('input[name="gallery[photo_gallery][]"]').value = '';
                    document.querySelector('input[name="gallery[color][]"]').value = '';
                    document.querySelector('input[name="gallery[size][]"]').value = '';
                    document.querySelector('input[name="gallery[price][]"]').value = '';
                    document.querySelector('input[name="gallery[stock][]"]').value = '';
                    
                }
                
            } else {
                alert('Please fill all fields');
            }
        });
    });
</script>
   
@endsection
