<?php

namespace App\Http\Controllers\Back;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use OwenIt\Auditing\Models\Audit;

class AuditController extends Controller
{
    public function index()
    {
        return view('back.audit.index',[
            'datas' => Audit::orderBy('id','desc')->get()
        ]);
    }
    
    public function destroy($id)
    {
        $audit = Audit::find($id);
        if ($audit) {
            $audit->delete();
            return redirect()->back()->with('success', 'Audit record deleted successfully.');
        }
        return redirect()->back()->with('error', 'Audit record not found.');
    }
}
