<?php

namespace App\Http\Controllers\Back;

use App\Http\Controllers\Controller;
use App\Models\FrontItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Helpers\ImageHelper;
class FrontItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $datas = FrontItem::orderBy('id','desc')->get();
        return view('back.frontitem.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('back.frontitem.create',[
            'front_item' => FrontItem::where('is_default',1)->first()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
{
    $validatedData = $request->validate([
        'name' => 'required|string|max:255',
        'description' => 'nullable|string',
        'photo' => 'required|image|mimes:jpg,jpeg,png',
    ]);

    // Use ImageHelper to handle the image upload
    $imagePath = ImageHelper::handleUploadedImage($request->file('photo'), 'assets/images');

    $front_item = FrontItem::create([
        'name' => $validatedData['name'],
        'description' => $validatedData['description'],
        'photo' => $imagePath,
    ]);

    return redirect()->route('back.front_item.index')->with('success', 'Item created successfully!');
}

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        return view('back.frontitem.edit',[
            'front_item' => FrontItem::where('is_default',1)->first()
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
       // Find the item by ID
    $front_item = FrontItem::findOrFail($id);

    // Validate the request data
    $validatedData = $request->validate([
        'name' => 'required|string|max:255',
        'description' => 'nullable|string',
        'photo' => 'nullable|image|mimes:jpg,jpeg,png', // Optional photo
    ]);

    // Handle photo upload if provided
    $imagePath = $front_item->photo; // Keep the old image path by default

    if ($request->hasFile('photo')) {
        // Use ImageHelper to handle upload and delete old photo
        $imagePath = ImageHelper::handleFrontItemImage(
            $request->file('photo'), // New image file
            'assets/images',        // Target folder
            $front_item->photo      // Old image to delete
        );
    }

    // Update the item with new data
    $front_item->update([
        'name' => $validatedData['name'],
        'description' => $validatedData['description'],
        'photo' => $imagePath, // Save the updated photo path
    ]);

    // Redirect back with success message
    return redirect()->route('back.front_item.index')->with('success', 'Item updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        // Find the item by ID
        $front_item = FrontItem::findOrFail($id);

        // Delete the photo file if it exists
        if ($front_item->photo) {
            Storage::disk('public')->delete($front_item->photo);
        }

        // Delete the item from the database
        $front_item->delete();

        // Return success response
        return redirect()->route('back.front_item.index')->with('success', 'Item Deleted successfully!');
    }

}
