<?php

namespace App\Http\Controllers\Back;

use App\{
    Models\Review,
    Http\Controllers\Controller
};
use App\Models\Item;
use Illuminate\Http\Request;
class ReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('back.review.index',[
            'datas' => Review::latest('id')->get()
        ]);
    }

    public function create()
    {
        $items = Item::get();
        return view('back.review.create', compact('items'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function save(Request $request)
    {
       // Validate the request data
       $validatedData = $request->validate([
        'user_id' => 'required|exists:users,id',    // Ensure user exists
        'item_id' => 'required|exists:items,id',   // Ensure item exists
        'review'  => 'required|string|max:1000',  // Limit the review length
        'rating'  => 'required|integer|between:1,5', // Rating between 1 and 5
        'status'  => 'required|in:approved,pending,rejected', // Valid statuses
        'subject' => 'required|string|max:255',    // Limit subject length
    ]);

    $review = Review::create([
        'user_id' => $validatedData['user_id'],
        'item_id' => $validatedData['item_id'],
        'rating' => $validatedData['rating'],
        'review' => $validatedData['review'],
        'status' => $validatedData['status'],
        'subject' => $validatedData['subject'],
    ]);
        
        //dd($review);
    
        return redirect()->route('back.review.index')->with('success', 'Review created successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Review $review)
    {
        return view('back.review.show',compact('review'));
    }

    /**
     * Change the status for editing the specified resource.
     *
     * @param  int  $id
     * @param  int  $pos
     * @return \Illuminate\Http\Response
     */
    public function status($id,$status)
    {
        $shipping = Review::find($id)->update(['status' => $status]);
        return redirect()->route('back.review.index')->withSuccess(__('Status Updated Successfully.'));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Review $review)
    {
        $review->delete();
        return redirect()->route('back.review.index')->withSuccess(__('Review Deleted Successfully.'));
    }
}
