@extends('master.back')

@section('content')

<!-- Start of Main Content -->
<div class="container-fluid">

	<!-- Page Heading -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h3 class=" mb-0bc-title"><b>{{ __('Audit Report') }}</b></h3>
                
                </div>
        </div>
    </div>


	<!-- DataTales -->
	<div class="card shadow mb-4">
		<div class="card-body">
			@include('alerts.alerts')
			<div class="table-responsive">
				<table class="table table-bordered table-striped" id="admin-table" width="100%" cellspacing="0">

					<thead>
						<tr>
                            <th>{{ __('Sl') }}</th>
							<th>{{ __('User') }}</th>
                            <th>{{ __('Event') }}</th>
                            <th>{{ __('Old Value') }}</th>
                            <th>{{ __('New Value') }}</th>
                            <th>{{ __('Updated Time') }}</th>
							<th>{{ __('Actions') }}</th>
						</tr>
					</thead>

					<tbody>
                        @php $index = 0; @endphp
                        @foreach($datas as $data)
                            @php $index++; @endphp
                            <tr>
                                <td>{{ $index }}</td>
                                <td>
                                    {{-- {{ $data->user->name }} --}}
                                </td>
                                <td>{{ $data->event }}</td>
                                <td>
                                    @if(is_array($data->old_values) && !empty($data->old_values))
                                        @foreach($data->old_values as $key => $value)
                                            <strong>{{ $key }}:</strong> {{ $value }}<br>
                                        @endforeach
                                    @elseif(!is_array($data->old_values) && !empty($data->old_values))
                                        {{ $data->old_values }}
                                    @else
                                        N/A
                                    @endif
                                </td>
                                
                                <td>
                                    @if(is_array($data->new_values) && !empty($data->new_values))
                                        @foreach($data->new_values as $key => $value)
                                            <strong>{{ $key }}:</strong> {{ $value }}<br>
                                        @endforeach
                                    @elseif(!is_array($data->new_values) && !empty($data->new_values))
                                        {{ $data->new_values }}
                                    @else
                                        N/A
                                    @endif
                                </td>
                                <td>{{ $data->updated_at }}</td>
                                
                                <td>
                                    <div class="action-list">
                                        <a class="btn btn-danger btn-sm btn-rounded" data-toggle="modal"
                                            data-target="#confirm-delete" href="javascript:;"
                                            data-href="{{ route('back.audit.destroy',$data->id) }}">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

					</tbody>

				</table>
			</div>
		</div>
	</div>

</div>

</div>
<!-- End of Main Content -->

{{-- DELETE MODAL --}}

  <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="confirm-deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">

		<!-- Modal Header -->
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">{{ __('Confirm Delete?') }}</h5>
          <button class="close" type="button" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
          </button>
		</div>

		<!-- Modal Body -->
        <div class="modal-body">
			{{ __('You are going to delete this page. All contents related with this page will be lost.') }} {{ __('Do you want to delete it?') }}
		</div>

		<!-- Modal footer -->
        <div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</button>
			<form action="" class="d-inline btn-ok" method="POST">

                @csrf

                @method('DELETE')

                <button type="submit" class="btn btn-danger">{{ __('Delete') }}</button>

			</form>
		</div>

      </div>
    </div>
  </div>

{{-- DELETE MODAL ENDS --}}

@endsection
