@extends('master.back')

@section('content')

<div class="container-fluid">

<!-- Page Heading -->
<div class="card mb-4">
    <div class="card-body">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h3 class="mb-0 bc-title"><b>{{ __('Create New Language') }}</b> </h3>
            <a class="btn btn-primary btn-sm" href="{{route('back.language.index')}}"><i class="fas fa-chevron-left"></i> {{ __('Back') }}</a>
        </div>
    </div>
</div>

<!-- Content Row -->
<div class="row">

    <div class="col-xl-12 col-lg-12">

        <form class="geniusform" action="{{ route('back.language.store') }}" method="POST" enctype="multipart/form-data">
            @include('alerts.alerts')
            @csrf

            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Set Language Name') }}</h6>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>{{ __('Language Name') }} *</label>
                        <input type="text" class="form-control" name="language" placeholder="{{ __('Enter Language Name') }}" required>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-secondary">{{ __('Submit') }}</button>
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Set Keywords & Values for Translation') }}</h6>
                </div>
                <div class="card-body p-4">
                    <div class="gd-responsive-table">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{{ __('Key') }}</th>
                                    <th>{{ __('Value') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody class="new-field">
                                <tr>
                                    <td><input type="text" class="form-control" name="keys[]" placeholder="{{ __('Enter Key') }}" required></td>
                                    <td><input type="text" class="form-control" name="values[]" placeholder="{{ __('Enter Value') }}" required></td>
                                    <td>
                                        <button class="btn btn-danger btn-sm remove-field"><i class="fas fa-trash"></i></button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Add More Button -->
                    <div class="row justify-content-center mt-4">
                        <button type="button" class="btn btn-secondary" id="add_more_language"><i class="fas fa-plus"></i> {{ __('Add More') }}</button>
                    </div>

                    <!-- Submit Button -->
                    <div class="row justify-content-center mt-4">
                        <button type="submit" class="btn btn-secondary">{{ __('Submit') }}</button>
                    </div>

                </div>
            </div>

        </form>

    </div>

</div>

</div>

@endsection

@section('scripts')
<script>
    // Add more fields
    $('#add_more_language').on('click', function() {
        $('.new-field').append(`
            <tr>
                <td><input type="text" class="form-control" name="keys[]" placeholder="{{ __('Enter Key') }}" required></td>
                <td><input type="text" class="form-control" name="values[]" placeholder="{{ __('Enter Value') }}" required></td>
                <td>
                    <button class="btn btn-danger btn-sm remove-field"><i class="fas fa-trash"></i></button>
                </td>
            </tr>
        `);
    });

    // Remove fields
    $(document).on('click', '.remove-field', function() {
        $(this).closest('tr').remove();
    });
</script>
@endsection