<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <link rel="icon"  type="image/x-icon" href="{{ asset('assets/images/'.$setting->favicon) }}"/>

  <title>{{ $setting->title }}</title>
<!-- Bootstrap -->
<link href="{{ asset('assets/front/css/bootstrap.min.css') }}" rel="stylesheet">

<link href="{{ asset('assets/front/css/fontawesome.min.css') }}" rel="stylesheet">
<link href="{{ asset('assets/front/css/magnific-popup.css') }}" rel="stylesheet">
<link href="{{ asset('assets/front/css/jquery-ui.css') }}" rel="stylesheet">

<link href="{{ asset('assets/front/css/animate.css') }}" rel="stylesheet">
<link href="{{ asset('assets/front/css/owl.carousel.min.css') }}" rel="stylesheet">

@yield('css')

<!-- Main css -->
<link href="{{ asset('assets/front/css/main.css') }}" rel="stylesheet">
</head>

<body id="invoice-print" onload="window.print()" id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">


    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        @php
        if($order->state){
            $state = json_decode($order->state,true);
        }else{
            $state = [];
        }
    @endphp
        <table style="
        width: 100%;
        border-collapse: collapse;
        font-size: 12px;
        position:relative;
        height: 97vh;
      ">
       <tr>
        <td>
          <img
            style="position: absolute; height: 100%; width: 100%; z-index: -1"
            src="{{ asset('assets/images/invoice_bg.jpg') }}"
            alt=""
          />
        </td>
      </tr>
      <!-- Header -->
      <tbody>
        <tr style="height: 150px;">

        </tr>

      <tr>
        <td colspan="4"><hr style="border: 1px solid #ddd"></td>
      </tr>

      <!-- Invoice Info -->
      <tr>
        <td colspan="2" style="text-align: left; padding: 8px">
          <strong>Date:</strong> {{ $order->created_at }}
        </td>
        <td colspan="2" style="text-align: right; padding: 8px">
          <strong>Invoice No:</strong> 23123
        </td>
      </tr>
      

      <tr>
        <td colspan="4"><hr style="border: 1px solid #ddd"></td>
      </tr>

      <!-- Invoice Address -->
      <tr>
        <td colspan="2" style="padding: 8px">
          <strong>Invoiced To:</strong>
          <ul style="list-style: none; padding-left: 0; margin: 0">
            <li>Some One</li>
          </ul>
        </td>
        <td colspan="2" style="padding: 8px; text-align: right">
          <strong>Pay To:</strong>
          <ul style="list-style: none; padding-left: 0; margin: 0">
            <li>Transaction Id: {{$order->txnid}}</li>
            <li>Transaction No. : {{$order->transaction_number}}</li>
            <li>Payment Method: {{$order->payment_method }}</li>
            <li>Payment Status :
                @if($order->payment_status == 'Paid')
                
                    {{__('Paid')}}
                
                @else
                
                    {{__('Unpaid')}}
                   
                @endif
            </li>
          </ul>
        </td>
      </tr>
      


      <tr>
        <td colspan="4"><hr style="border: 1px solid #ddd"></td>
      </tr>

      <!-- Service Info -->
      <tr>
        <td colspan="4" style="padding: 10px">
          <strong>Service</strong>
        </td>
      </tr>
      <tr>
        <td colspan="4" style="padding: 10px">
          <table style="border-collapse: collapse; width: 250px">
            <tbody><tr>
              <td style="width: 70px">
                <img src="./assets/img/services/new-service-1.png" alt="Service" style="width: 65px">
              </td>
              <td style="font-size: 12px">
                Business Registration and File Management
              </td>
            </tr>
          </tbody></table>
        </td>
      </tr>

      <!-- Order Summary -->
      <tr>
        <td colspan="4" style="padding: 10px">
          <strong>Order Summary</strong>
        </td>
      </tr>
      <tr>
        <td colspan="4">
          <table style="
              width: 100%;
              border-collapse: collapse;
              font-size: 12px;
            ">
            <thead>
                <tr>
                    <th>Products</th>
                    <th>Attribute</th>
                    <th>Quantity</th>
                    <th>Price</th>
                </tr>
            </thead>
            <tbody>
                @php
                        $option_price = 0;
                        $total = 0;
                    @endphp
                @foreach (json_decode($order->cart,true) as $item)
                    @php
                        $total += $item['main_price'] * $item['qty'];
                        $option_price += $item['attribute_price'];
                        $grandSubtotal = $total + $option_price;
                    @endphp
                    <tr style="
                        border-top: 1px solid #ddd;
                        border-bottom: 1px solid #ddd;
                        ">
                        <td style="padding: 15px">{{$item['name']}}</td>
                        <td style="padding: 15px">
                            @if($item['attribute']['option_name'])
                                @foreach ($item['attribute']['option_name'] as $optionkey => $option_name)
                                <span class="entry-meta"><b>{{$option_name}}</b> :
                                    @if ($setting->currency_direction == 1)
                                    {{$order->currency_sign}}{{round($item['attribute']['option_price'][$optionkey]*$order->currency_value,2)}}
                                    @else
                                    {{round($item['attribute']['option_price'][$optionkey]*$order->currency_value,2)}}{{$order->currency_sign}}
                                    @endif

                                </span>
                                @endforeach
                            @else
                            --
                            @endif
                        </td>
                        <td style="padding: 15px; text-align: right">
                            {{$item['qty']}}
                        </td>
                        <td style="padding: 15px; text-align: right">
                            @if ($setting->currency_direction == 1)
                            {{$order->currency_sign}}{{round($item['main_price']*$order->currency_value,2)}}
                            @else
                                {{round($item['main_price']*$order->currency_value,2)}}{{$order->currency_sign}}
                            @endif
                        </td>
                    </tr>
                @endforeach
                <tr>
                    <td class="padding-top-2x" colspan="5">
                    </td>
                </tr>
                @if($order->tax!=0)
                    <tr>
                        <td class="px-0 border-top border-top-2">
                            <span class="text-muted">{{__('Tax')}}</span>
                        </td>
                        <td class="px-0 text-right border-top border-top-2" colspan="5">
                            <span>
                            @if ($setting->currency_direction == 1)
                                {{$order->currency_sign}}{{round($order->tax*$order->currency_value,2)}}
                            @else
                            {{round($order->tax*$order->currency_value,2)}}{{$order->currency_sign}}
                            @endif
                            </span>
                        </td>
                    </tr>
                    @endif
                    @if(json_decode($order->discount,true))
                        @php
                            $discount = json_decode($order->discount,true);
                        @endphp
                        <tr>
                        <td class="px-0 border-top border-top-2">
                        <span class="text-muted">{{__('Coupon discount')}} ({{$discount['code']['code_name']}})</span>
                        </td>
                        <td class="px-0 text-right border-top border-top-2" colspan="5">
                            <span class="text-danger">
                            @if ($setting->currency_direction == 1)
                                -{{$order->currency_sign}}{{round($discount['discount'] * $order->currency_value,2)}}
                            @else
                                -{{round($discount['discount'] * $order->currency_value,2)}}{{$order->currency_sign}}
                            @endif
                            </span>
                        </td>
                        </tr>
                        @endif
                        @if(json_decode($order->shipping,true))
                        @php
                            $shipping = json_decode($order->shipping,true);
                        @endphp
                        <tr>
                        <td class="px-0 border-top border-top-2">
                        <span class="text-muted">{{__('Shipping')}}</span>
                        </td>
                        <td class="px-0 text-right border-top border-top-2" colspan="5">
                            <span >
                            @if ($setting->currency_direction == 1)
                                {{$order->currency_sign}}{{round($shipping['price']*$order->currency_value,2)}}
                            @else
                                {{round($shipping['price']*$order->currency_value,2)}}{{$order->currency_sign}}
                            @endif

                            </span>
                        </td>
                        </tr>
                        @endif
                        @if(json_decode($order->state_price,true))
                        <tr>
                        <td class="px-0 border-top border-top-2">
                        <span class="text-muted">{{__('Delivery Cost')}}</span>
                        </td>
                        <td class="px-0 text-right border-top border-top-2" colspan="5">
                            <span >
                            @if ($setting->currency_direction == 1)
                            {{isset($state['type']) && $state['type'] == 'percentage' ?  ' ('.$state['price'].'%) ' : ''}}  {{$order->currency_sign}}{{round($order['state_price']*$order->currency_value,2)}}
                            @else
                            {{isset($state['type']) &&  $state['type'] == 'percentage' ?  ' ('.$state['price'].'%) ' : ''}}  {{round($order['state_price']*$order->currency_value,2)}}{{$order->currency_sign}}
                            @endif

                            </span>
                        </td>
                        </tr>
                    @endif
                    <tr>
                        <td class="px-0 border-top border-top-2">

                            @if ($order->payment_method == 'Cash On Delivery')
                                <strong>{{__('Total amount')}}</strong>
                            @else
                                <strong>{{__('Total amount due')}}</strong>
                            @endif
                        </td>
                        <td class="px-0 text-right border-top border-top-2" colspan="5">
                            <span class="h3">
                                @if ($setting->currency_direction == 1)
                                {{$order->currency_sign}}{{PriceHelper::OrderTotal($order)}}
                                @else
                                {{PriceHelper::OrderTotal($order)}}{{$order->currency_sign}}
                                @endif
                            </span>
                        </td>
                    </tr>
              <tr style="
                  border-top: 1px solid #ddd;
                  border-bottom: 1px solid #ddd;
                ">
                <td style="padding: 15px">Service Charge</td>
                <td style="padding: 15px; text-align: right">
                  ৳ <span>2,000</span>
                </td>
              </tr>
              <tr style="
                  border-top: 1px solid #ddd;
                  border-bottom: 1px solid #ddd;
                ">
                <td style="padding: 15px">
                  <strong>Total Charge</strong>
                </td>
                <td style="padding: 15px; text-align: right">
                  <strong>৳ <span>4,600</span></strong>
                </td>
              </tr>
            </tbody>
          </table>
        </td>
      </tr>

      <!-- Note -->
      <tr>
        <td colspan="4" style="text-align: center; padding: 50px 0">
          <p style="margin: 0">
            NOTE: This is a computer-generated receipt and does not
            require a physical signature.
          </p>
        </td>
      </tr>
    </tbody>
</table>

      </div>
      <!-- End of Main Content -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

</body>

</html>

