@extends('master.back')

@section('content')
<link rel="stylesheet" href="{{asset('assets/back/css/select2.css')}}">
<div class="container-fluid">

	<!-- Page Heading -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h3 class="mb-0 bc-title"><b>{{ __('Create Custom Review') }}</b> </h3>
                <a class="btn btn-primary btn-sm" href="{{route('back.review.index')}}"><i class="fas fa-chevron-left"></i> {{ __('Back') }}</a>
                </div>
        </div>
    </div>

	<!-- Form -->
	<div class="row">

		<div class="col-xl-12 col-lg-12 col-md-12">

			<div class="card o-hidden border-0 shadow-lg">
				<div class="card-body ">
					<!-- Nested Row within Card Body -->
					<div class="row justify-content-center">
						<div class="col-lg-12">
              <form action="{{ route('review.save') }}" method="POST">
                @csrf
                <input class="form-control" type="hidden" id="user_id" name="user_id" value="1" required>
                <div class="form-group">
                    <label for="item_id">{{ __('Item') }}</label>
                    <select class="form-control" name="item_id" id="item_id">
                      @foreach($items as $item)
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                      @endforeach
                    </select>
                    {{-- <input class="form-control" type="number" id="item_id" name="item_id" required> --}}
                </div>
                <div class="form-group">
                    <label for="review-subject">{{ __('Subject') }}</label>
                    <input class="form-control" type="text" name="subject" id="review-subject" required>
                </div>
                <div class="form-group">
                    <label for="review-rating">{{ __('Rating') }}</label>
                    <select name="rating" class="form-control" id="review-rating">
                        <option value="5">5 {{__('Stars')}}</option>
                        <option value="4">4 {{__('Stars')}}</option>
                        <option value="3">3 {{__('Stars')}}</option>
                        <option value="2">2 {{__('Stars')}}</option>
                        <option value="1">1 {{__('Star')}}</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="review-message">{{ __('Review') }}</label>
                    <textarea class="form-control" name="review" id="review-message" rows="8" required></textarea>
                </div>
                <input type="hidden" name="status" value="pending">
                <button class="btn btn-primary" type="submit">{{ __('Submit Review') }}</button>
            </form>
            
						</div>
					</div>
				</div>
			</div>

		</div>

	</div>

</div>

@endsection
@section('scripts')
    <script type="" src="{{asset('assets/back/js/select2.js')}}"></script>
    <script>
        $('#basic').select2({
			theme: "bootstrap"
		});
    </script>
@endsection