@extends('master.front')
@section('meta')
<meta name="keywords" content="{{$setting->meta_keywords}}">
<meta name="description" content="{{$setting->meta_description}}">
@endsection
@section('title')
    {{__('Products')}}
@endsection

@section('content')
    <!-- Page Title-->
<div class="page-title">
    <div class="container">
      <div class="row">
          <div class="col-lg-12">
            <ul class="breadcrumbs">
                <li><a href="{{route('front.index')}}">{{__('Home')}}</a> </li>
                <li class="separator"></li>
                <li>{{__('Shop')}}</li>
              </ul>
          </div>
      </div>
    </div>
  </div>
  <!-- Page Content-->
  <div class="container padding-bottom-3x mb-1">
        <div class="row">
            <div class="col-lg-12">
                <div class="shop-top-filter-wrapper">
                    <div class="row">
                        <div class="col-md-10 gd-text-sm-center">
                            <div class="sptfl">
                                <div class="quickFilter">
                                    <h4 class="quickFilter-title"><i class="fas fa-filter"></i>{{__('Quick filter')}}</h4>
                                    <ul id="quick_filter">
                                        <li><a datahref=""><i class="icon-chevron-right pr-2"></i>{{__('All products')}} </a></li>
                                        <li class=""><a href="javascript:;" data-href="feature"><i class="icon-chevron-right pr-2"></i>{{__('Featured products')}} </a></li>
                                        <li class=""><a href="javascript:;" data-href="best"><i class="icon-chevron-right pr-2"></i>{{__('Best sellers')}} </a></li>
                                        <li class=""><a href="javascript:;" data-href="top"><i class="icon-chevron-right pr-2"></i>{{__('Top rated')}} </a></li>
                                        <li class=""><a href="javascript:;" data-href="new"><i class="icon-chevron-right pr-2"></i>{{__('New Arrival')}} </a></li>
                                    </ul>
                                </div>
                                <div class="shop-sorting">
                                    <label for="sorting">{{__('Sort by')}}:</label>
                                    <select class="form-control" id="sorting">
                                    <option value="">{{__('All Products')}}</option>
                                    <option value="low_to_high" {{request()->input('low_to_high') ? 'selected' : ''}}>{{__('Low - High Price')}}</option>
                                    <option value="high_to_low" {{request()->input('high_to_low') ? 'selected' : ''}}>{{__('High - Low Price')}}</option>
                                    </select><span class="text-muted">{{__('Showing')}}:</span><span>1 - {{$setting->view_product}} {{__('items')}}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 gd-text-sm-center">
                            <div class="shop-view"><a class="list-view {{Session::has('view_catalog') && Session::get('view_catalog') == 'grid' ? 'active' : ''}} " data-step="grid" href="javascript:;" data-href="{{route('front.catalog').'?view_check=grid'}}"><i class="fas fa-th-large"></i></a>
                                <a class="list-view {{Session::has('view_catalog') && Session::get('view_catalog') == 'list' ? 'active' : ''}}" href="javascript:;" data-step="list" data-href="{{route('front.catalog').'?view_check=list'}}"><i class="fas fa-list"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-3">

          <div class="col-lg-9 order-lg-2" id="list_view_ajax">
            @include('front.catalog.catalog')
          </div>

          <!-- Sidebar          -->
          <div class="col-lg-3 order-lg-1">
            <div class="sidebar-toggle position-left"><i class="icon-filter"></i></div>
            <aside class="sidebar sidebar-offcanvas position-left"><span class="sidebar-close"><i class="icon-x"></i></span>
              <!-- Widget Categories-->
              <section class="widget widget-categories card rounded p-4">
                <h3 class="widget-title">{{__('Shop Categories')}}</h3>
                <ul id="category_list" class="category-scroll">
                    @foreach ($categories as $getcategory)
                    <li class="has-children  {{isset($category) && $category->id == $getcategory->id ? 'expanded active' : ''}} ">
                      <a class="category_search" href="javascript:;"  data-href="{{$getcategory->slug}}">{{$getcategory->name}}</a>

                        <ul id="subcategory_list">
                            @foreach ($getcategory->subcategory as $getsubcategory)
                            <li class="{{isset($subcategory) && $subcategory->id == $getsubcategory->id ? 'active' : ''}}">
                              <a class="subcategory" href="javascript:;" data-href="{{$getsubcategory->slug}}">{{$getsubcategory->name}}</a>

                              <ul id="childcategory_list">
                                @foreach ($getsubcategory->childcategory as $getchildcategory)
                                <li class="{{isset($childcategory) && $getchildcategory->id == $getchildcategory->id ? 'active' : ''}}">
                                  <a class="childcategory" href="javascript:;" data-href="{{$getchildcategory->slug}}">{{$getchildcategory->name}}</a>

                                </li>
                                @endforeach
                            </ul>
                            </li>
                            @endforeach
                        </ul>
                      </li>
                    @endforeach
                </ul>
              </section>

              @if ($setting->is_range_search == 1)
                  <!-- Widget Price Range -->
                  <section class="widget widget-categories card rounded p-4">
                      <h3 class="widget-title">{{ __('Filter by Price') }}</h3>
                      <form class="price-range-slider" method="GET" action="{{ url()->current() }}">
                          <!-- Hidden Inputs for Form Submission -->
                          <input type="hidden" name="minPrice" id="min_price_input" value="{{ request()->input('minPrice', 0) }}">
                          <input type="hidden" name="maxPrice" id="max_price_input" value="{{ request()->input('maxPrice', $setting->max_price) }}">

                          <!-- Slider -->
                          <div class="ui-range-slider" 
                              data-start-min="{{ request()->input('minPrice', 0) }}"
                              data-start-max="{{ request()->input('maxPrice', $setting->max_price) }}"
                              data-min="0" 
                              data-max="{{ $setting->max_price }}" 
                              data-step="5">
                          </div>

                          <!-- Manual Input for Min and Max Prices -->
                          <div class="price-inputs mt-3">
                              <div class="row">
                                  <div class="col-6">
                                      <label for="min_price_field">{{ __('Min Price') }}</label>
                                      <input type="number" id="min_price_field" class="form-control" 
                                          value="{{ request()->input('minPrice', 0) }}" 
                                          min="0" max="{{ $setting->max_price }}">
                                  </div>
                                  <div class="col-6">
                                      <label for="max_price_field">{{ __('Max Price') }}</label>
                                      <input type="number" id="max_price_field" class="form-control" 
                                          value="{{ request()->input('maxPrice', $setting->max_price) }}" 
                                          min="0" max="{{ $setting->max_price }}">
                                  </div>
                              </div>
                          </div>

                          <footer class="ui-range-slider-footer mt-3">
                              <div class="column">
                                  <button class="btn btn-primary btn-sm" id="price_filter" type="submit">
                                      <span>{{ __('Filter') }}</span>
                                  </button>
                              </div>
                          </footer>
                      </form>
                  </section>
              @endif

              @if ($setting->is_attribute_search == 1)
              @foreach ($attributes as $attribute)
              
              <section class="widget widget-categories card rounded p-4">
                <h3 class="widget-title">{{ __('Filter by') }} {{$attribute->name}}</h3>
                @foreach ($attribute->options as $option)

                @if ($attribute->keyword == $option->attribute->keyword)
                <div class="custom-control custom-checkbox">
                  <input class="custom-control-input option" {{isset($subcategory) && $subcategory->id == $option->id ? 'checked' : ''}}   type="checkbox" value="{{$option->name}}" id="{{$attribute->id}}{{$option->name}}">
                  <label class="custom-control-label" for="{{$attribute->id}}{{$option->name}}">{{$option->name}}<span class="text-muted"></span></label>
              </div>  
                @endif
                @endforeach
              </section>
              @endforeach
              @endif

              <!-- Widget Brand Filter-->
              <section class="widget widget-categories card rounded p-4">
                <h3 class="widget-title">{{__('Filter by Brand')}}</h3>
                <div class="custom-control custom-checkbox">
                  <input class="custom-control-input brand-select" type="checkbox" value="" id="all-brand">
                  <label class="custom-control-label" for="all-brand">{{__('All Brands')}}</label>
                </div>
                @foreach ($brands as $getbrand)
                <div class="custom-control custom-checkbox">
                    <input class="custom-control-input brand-select" {{isset($brand) && $brand->id == $getbrand->id ? 'checked' : ''}} type="checkbox" value="{{$getbrand->slug}}" id="{{$getbrand->slug}}">
                    <label class="custom-control-label" for="{{$getbrand->slug}}">{{$getbrand->name}}</label>
                  </div>
                @endforeach
              </section>


            </aside>
          </div>
        </div>
      </div>



      <form id="search_form" class="d-none" action="{{route('front.catalog')}}" method="GET">

        <input type="text" name="maxPrice" id="maxPrice" value="{{request()->input('maxPrice') ? request()->input('maxPrice') : ''}}">
        <input type="text" name="minPrice" id="minPrice" value="{{request()->input('minPrice') ? request()->input('minPrice') : ''}}">
        <input type="text" name="brand" id="brand" value="{{isset($brand) ? $brand->slug : ''}}">
        <input type="text" name="brand" id="brand" value="{{isset($brand) ? $brand->slug : ''}}">
        <input type="text" name="category" id="category" value="{{isset($category) ? $category->slug : ''}}">
        <input type="text" name="quick_filter" id="quick_filter" value="">
        <input type="text" name="childcategory" id="childcategory" value="{{isset($childcategory) ? $childcategory->slug : ''}}">
        <input type="text" name="page" id="page" value="{{isset($page) ? $page : ''}}">
        <input type="text" name="attribute" id="attribute" value="{{isset($attribute) ? $attribute : ''}}">
        <input type="text" name="option" id="option" value="{{isset($option) ? $option : ''}}">
        <input type="text" name="subcategory" id="subcategory" value="{{isset($subcategory) ? $subcategory->slug : ''}}">
        <input type="text" name="sorting" id="sorting" value="{{isset($sorting) ? $sorting : ''}}">
        <input type="text" name="view_check" id="view_check" value="{{isset($view_check) ? $view_check : ''}}">


        <button type="submit" id="search_button" class="d-none"></button>
    </form>
@endsection

<script>
  document.addEventListener("DOMContentLoaded", function () {
      const minPriceInput = document.getElementById('min_price_input');
      const maxPriceInput = document.getElementById('max_price_input');
      
      const minPriceField = document.getElementById('min_price_field');
      const maxPriceField = document.getElementById('max_price_field');
      
      const rangeSlider = document.querySelector('.ui-range-slider');

      // Initialize the range slider (using noUiSlider as an example)
      noUiSlider.create(rangeSlider, {
          start: [parseInt(minPriceField.value), parseInt(maxPriceField.value)],
          connect: true,
          range: {
              'min': parseInt(rangeSlider.dataset.min),
              'max': parseInt(rangeSlider.dataset.max)
          },
          step: parseInt(rangeSlider.dataset.step)
      });

      // Update the inputs when the slider is moved
      rangeSlider.noUiSlider.on('update', function (values) {
          const minValue = Math.round(values[0]);
          const maxValue = Math.round(values[1]);

          minPriceField.value = minValue;
          maxPriceField.value = maxValue;

          minPriceInput.value = minValue;
          maxPriceInput.value = maxValue;
      });

      // Update the slider when the input fields are changed
      minPriceField.addEventListener('change', function () {
          rangeSlider.noUiSlider.set([this.value, null]);
      });

      maxPriceField.addEventListener('change', function () {
          rangeSlider.noUiSlider.set([null, this.value]);
      });
  });
</script>