<?php $__env->startSection('content'); ?>

<div class="container-fluid">

<!-- Page Heading -->
<div class="card mb-4">
    <div class="card-body">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h3 class="mb-0 bc-title"><b><?php echo e(__('Create Product')); ?></b> </h3>
            <a class="btn btn-primary   btn-sm" href="<?php echo e(route('back.item.index')); ?>"><i class="fas fa-chevron-left"></i> <?php echo e(__('Back')); ?></a>
        </div>
    </div>
</div>

<!-- Form -->


<div class="row">
    <div class="col-lg-12">
            <?php echo $__env->make('alerts.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<!-- Nested Row within Card Body -->
<form id="myForm" class="admin-form tab-form" action="<?php echo e(route('back.item.store')); ?>" method="POST"
                enctype="multipart/form-data">
                <input type="hidden" value="normal" name="item_type">
                <?php echo csrf_field(); ?>
    <div class="row">

        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="name"><?php echo e(__('Name')); ?> *</label>
                        <input type="text" name="name" class="form-control item-name"
                            id="name" placeholder="<?php echo e(__('Enter Name')); ?>"
                            value="<?php echo e(old('name')); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="slug"><?php echo e(__('Slug')); ?> *</label>
                        <input type="text" name="slug" class="form-control"
                            id="slug" placeholder="<?php echo e(__('Enter Slug')); ?>"
                            value="<?php echo e(old('slug')); ?>" >
                    </div>
                </div>
            </div>
           
            <div class="card">
                <div class="card-body">
                    <div class="form-group pb-0  mb-0">
                        <label class="d-block"><?php echo e(__('Featured Image')); ?> *</label>
                    </div>
                    <div class="form-group pb-0 pt-0 mt-0 mb-0">
                    <img class="admin-img lg" src="" >
                    </div>
                    <div class="form-group position-relative ">
                        <label class="file">
                            <input type="file"  accept="image/*"   class="upload-photo" name="photo"
                                id="file"  aria-label="File browser example">
                            <span
                                class="file-custom text-left"><?php echo e(__('Upload Image...')); ?></span>
                        </label>
                        <br>
                        <span class="mt-1 text-info"><?php echo e(__('Image Size Should Be 800 x 800. or square size')); ?></span>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-body">
                    <div class="form-group pb-0  mb-0">
                        <label class="d-block"><?php echo e(__('Pre Order Image')); ?> </label>
                    </div>
                    <div class="form-group pb-0 pt-0 mt-0 mb-0">
                    <img class="admin-img lg" src="" >
                    </div>
                    <div class="form-group position-relative ">
                        <label class="file">
                            <input type="file"  accept="image/*"   class="upload-photo" name="pre_order_image"
                                id="file"  aria-label="File browser example">
                            <span
                                class="file-custom text-left"><?php echo e(__('Upload Image...')); ?></span>
                        </label>
                        <br>
                        <span class="mt-1 text-info"><?php echo e(__('Image Size Should Be 200 x 200. or square size')); ?></span>
                    </div>
                </div>
            </div>
             <!-- Gallery Data Inputs -->
             <div class="card">
                <div class="card-body">
                    <div class="form-group" style="padding:2%">
                        <label for="inputEmail1" class="col-md-2 control-label">Gallery Images</label>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="photo_gallery">Photo</label>
                                <input type="file" class="form-control" id="photo_gallery" 
                                name="gallery[photo_gallery][]">
                            </div>
                            <div class="col-md-2">
                                <label for="color">Color</label>
                                <input type="text" class="form-control" placeholder="Color" id="color" name="gallery[color][]">
                            </div>
                            <div class="col-md-2">
                                <label for="size">Size</label>
                                <input type="text" class="form-control" placeholder="Size" id="size" name="gallery[size][]">
                            </div>
                            <div class="col-md-2">
                                <label for="price">Price</label>
                                <input type="number" class="form-control" placeholder="Price" id="price" name="gallery[price][]">
                            </div>
                            <div class="col-md-2">
                                <label for="stock">Stock</label>
                                <input type="number" class="form-control" placeholder="Stock" id="stock" name="gallery[stock][]">
                            </div>
                            <div class="col-md-1">
                                <label></label>
                                <button type="button" class="btn btn-success" id="add_items">+ Add</button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="inputEmail1" class="col-md-2 control-label">Item</label>
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered table-hover" id="mytable">
                                <tr>
                                    <th>Photo</th>
                                    <th>Color</th>
                                    <th>Size</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Action</th>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        
            <!-- Hidden input to store gallery data as JSON -->
            
    
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="sort_details"><?php echo e(__('Short Description')); ?> *</label>
                        <textarea name="sort_details" id="sort_details"
                            class="form-control"
                            placeholder="<?php echo e(__('Short Description')); ?>"
                            ><?php echo e(old('sort_details')); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label for="details"><?php echo e(__('Description')); ?> *</label>
                        <textarea name="details" id="details"
                            class="form-control text-editor"
                            rows="6"
                            placeholder="<?php echo e(__('Enter Description')); ?>"
                            ><?php echo e(old('details')); ?></textarea>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group mb-2">
                        <label for="tags"><?php echo e(__('Product Tags')); ?>

                            </label>
                        <input type="text" name="tags" class="tags"
                            id="tags"
                            placeholder="<?php echo e(__('Tags')); ?>"
                            value="">
                    </div>
                    <div class="form-group">
                        <label class="switch-primary">
                            <input type="checkbox" class="switch switch-bootstrap status radio-check" name="is_specification" value="1" checked>
                            <span class="switch-body"></span>
                            <span class="switch-text"><?php echo e(__('Specifications')); ?></span>
                        </label>
                    </div>
                    <div id="specifications-section">
                        <div class="d-flex">

                            <div class="flex-grow-1">
                                <div class="form-group">
                                    <input type="text" class="form-control"
                                        name="specification_name[]"
                                        placeholder="<?php echo e(__('Specification Name')); ?>" value="">
                                    </div>
                            </div>
                            <div class="flex-grow-1">
                                <div class="form-group">
                                    <input type="text" class="form-control"
                                        name="specification_description[]"
                                        placeholder="<?php echo e(__('Specification description')); ?>" value="">
                                    </div>
                            </div>
                            <div class="flex-btn">
                                <button type="button" class="btn btn-success add-specification" data-text="<?php echo e(__('Specification Name')); ?>" data-text1="<?php echo e(__('Specification Description')); ?>"> <i class="fa fa-plus"></i> </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="meta_keywords"><?php echo e(__('Meta Keywords')); ?>

                            </label>
                        <input type="text" name="meta_keywords" class="tags"
                            id="meta_keywords"
                            placeholder="<?php echo e(__('Enter Meta Keywords')); ?>"
                            value="">
                    </div>

                    <div class="form-group">
                        <label
                            for="meta_description"><?php echo e(__('Meta Description')); ?>

                            </label>
                        <textarea name="meta_description" id="meta_description"
                            class="form-control" rows="5"
                            placeholder="<?php echo e(__('Enter Meta Description')); ?>"
                        ><?php echo e(old('meta_description')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="discount_price"><?php echo e(__('Current Price')); ?>

                            *</label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span
                                    class="input-group-text"><?php echo e(PriceHelper::adminCurrency()); ?></span>
                            </div>
                            <input type="text" id="discount_price"
                                name="discount_price" class="form-control"
                                placeholder="<?php echo e(__('Enter Current Price')); ?>"
                                min="1" step="0.1"
                                value="<?php echo e(old('discount_price')); ?>" >
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="previous_price"><?php echo e(__('Previous Price')); ?>

                            </label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span
                                    class="input-group-text"><?php echo e($curr->sign); ?></span>
                            </div>
                            <input type="text" id="previous_price"
                                name="previous_price" class="form-control"
                                placeholder="<?php echo e(__('Enter Previous Price')); ?>"
                                min="1" step="0.1"
                                value="<?php echo e(old('previous_price')); ?>" >
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">

                    <div class="form-group">
                        <label for="category_id"><?php echo e(__('Select Category')); ?> *</label>
                        <select name="category_id" id="category_id" data-href="<?php echo e(route('back.get.subcategory')); ?>" class="form-control" >
                            <option value="" selected><?php echo e(__('Select One')); ?></option>
                            <?php $__currentLoopData = DB::table('categories')->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="subcategory_id"><?php echo e(__('Select Sub Category')); ?> </label>
                        <select name="subcategory_id" id="subcategory_id" data-href="<?php echo e(route('back.get.childcategory')); ?>" class="form-control">
                            <option value=""><?php echo e(__('Select One')); ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="childcategory_id"><?php echo e(__('Select Child Category')); ?> </label>
                        <select name="childcategory_id" id="childcategory_id" class="form-control">
                            <option value=""><?php echo e(__('Select One')); ?></option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="brand_id"><?php echo e(__('Select Brand')); ?> </label>
                        <select name="brand_id" id="brand_id" class="form-control" >
                            <option value="" selected><?php echo e(__('Select Brand')); ?></option>
                            <?php $__currentLoopData = DB::table('brands')->whereStatus(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <label for="stock"><?php echo e(__('Total in stock')); ?>

                            *</label>
                        <div class="input-group mb-3">
                            <input type="number" id="stock"
                                name="stock" class="form-control"
                                placeholder="<?php echo e(__('Total in stock')); ?>" value="<?php echo e(old('stock')); ?>" >
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="tax_id"><?php echo e(__('Select Tax')); ?> *</label>
                        <select name="tax_id" id="tax_id" class="form-control">
                            <?php $__currentLoopData = DB::table('taxes')->where('status', 1)->orderBy('id', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tax->id); ?>"><?php echo e($tax->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="sku"><?php echo e(__('SKU')); ?> *</label>
                        <input type="text" name="sku" class="form-control"
                            id="sku" placeholder="<?php echo e(__('Enter SKU')); ?>"
                            value="<?php echo e(Str::random(10)); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="video"><?php echo e(__('Video Link')); ?> </label>
                        <input type="text" name="video" class="form-control"
                            id="video" placeholder="<?php echo e(__('Enter Video Link')); ?>"
                            value="<?php echo e(old('video')); ?>">
                    </div>
                    <div class="form-group">
                        <label for="hangingTime"><?php echo e(__('Enter Hanging Time (Days)')); ?> </label>
                        <input type="number" name="hangingTime" class="form-control"
                            id="hangingTime" placeholder="<?php echo e(__('Enter Hanging Time')); ?>"
                            value="<?php echo e(old('hangingTime')); ?>">
                    </div>
                    <div class="form-group">
                        <label for="pre_order_active"><?php echo e(__('Pre-Order Product')); ?> </label>
                        <select class="form-control" name="pre_order_active" id="pre_order_active">
                            <option value="0">No</option>
                            <option value="">Yes</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <input type="hidden" class="check_button" name="is_button" value="0">
                    <button type="submit" class="btn btn-secondary mr-2"><?php echo e(__('Save')); ?></button>
                    <button type="submit" class="btn btn-info save__edit"><?php echo e(__('Save & Edit')); ?></button>
                </div>
            </div>
        </div>

    </div>
</form>


</div>

</div>
<script>
    let imageCounter = 1; 
    let imageIdCounter = 0;

    document.getElementById('gallery_file_0').addEventListener('change', handleImagePreview);

    function handleImagePreview(event) {
        let galleryPreview = document.getElementById('galleryPreview');
        let files = event.target.files;

        if (files) {
            Array.from(files).forEach(file => {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let imageWrapper = document.createElement('div');
                    imageWrapper.classList.add('image-wrapper');
                    imageWrapper.style.display = 'inline-block';
                    imageWrapper.style.position = 'relative';
                    imageWrapper.id = 'image_' + imageIdCounter; 

                    // Create the image element
                    let imgElement = document.createElement('img');
                    imgElement.src = e.target.result;
                    imgElement.style.maxWidth = '100px';
                    imgElement.style.margin = '5px';

                    // Create delete button
                    let deleteBtn = document.createElement('button');
                    deleteBtn.innerHTML = '×'; // Cross symbol for delete
                    deleteBtn.classList.add('delete-btn');
                    deleteBtn.style.position = 'absolute';
                    deleteBtn.style.top = '5px';
                    deleteBtn.style.right = '5px';
                    deleteBtn.style.background = 'red';
                    deleteBtn.style.color = 'white';
                    deleteBtn.style.border = 'none';
                    deleteBtn.style.borderRadius = '50%';
                    deleteBtn.style.width = '20px';
                    deleteBtn.style.height = '20px';
                    deleteBtn.style.cursor = 'pointer';

                    // Add event listener to delete the image on click
                    deleteBtn.addEventListener('click', function() {
                        galleryPreview.removeChild(imageWrapper);
                    });

                    // Append the image and delete button to the image wrapper
                    imageWrapper.appendChild(imgElement);
                    imageWrapper.appendChild(deleteBtn);

                    // Append the image wrapper to the gallery preview area
                    galleryPreview.appendChild(imageWrapper);

                    imageIdCounter++; 
                }
                reader.readAsDataURL(file);
            });
        }
    }
</script>

<!-- Load jQuery (Required) -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.3/jquery.validate.min.js"></script>



<script>
    $(document).ready(function () {
        document.getElementById('add_items').addEventListener('click', function () {
            const photo = document.querySelector('input[name="gallery[photo_gallery][]"]').files[0];
            const color = document.querySelector('input[name="gallery[color][]"]').value;
            const size = document.querySelector('input[name="gallery[size][]"]').value;
            const price = document.querySelector('input[name="gallery[price][]"]').value;
            const stock = document.querySelector('input[name="gallery[stock][]"]').value;

            // Only require the photo field
            if (photo) {
                const reader = new FileReader();
                reader.readAsDataURL(photo);
                reader.onload = function () {
                    const base64Photo = reader.result;
                    const table = document.getElementById('mytable').getElementsByTagName('tbody')[0];
                    const row = table.insertRow();
                    row.innerHTML = `
                        <td><img src="${URL.createObjectURL(photo)}" width="50"><input type="hidden" name="gallery_photo[]" value="${base64Photo}"></td>
                        <td>${color} <input type="hidden" name="gallery_color[]" value="${color}"> </td>
                        <td>${size} <input type="hidden" name="gallery_size[]" value="${size}"></td>
                        <td>${price} <input type="hidden" name="gallery_price[]" value="${price}"></td>
                        <td>${stock} <input type="hidden" name="gallery_stock[]" value="${stock}"></td>
                        <td><button type="button" class="btn btn-danger btn-sm remove-item">Remove</button></td>
                    `;

                    // Clear the form
                    document.querySelector('input[name="gallery[photo_gallery][]"]').value = '';
                    document.querySelector('input[name="gallery[color][]"]').value = '';
                    document.querySelector('input[name="gallery[size][]"]').value = '';
                    document.querySelector('input[name="gallery[price][]"]').value = '';
                    document.querySelector('input[name="gallery[stock][]"]').value = '';
                };
            } else {
                alert('Please upload a photo.');
            }
        });

        // Remove item from the table
        $(document).on('click', '.remove-item', function () {
            $(this).closest('tr').remove();
        });
    });
</script>  
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.back', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\shhabib\core\resources\views/back/item/create.blade.php ENDPATH**/ ?>