<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($setting->meta_keywords); ?>">
    <meta name="description" content="<?php echo e($setting->meta_description); ?>">
<?php $__env->stopSection(); ?>
<style>
    .rotate-box {
        display: grid;
        place-items: center;
        height: 200px;
        width: 200px;
        overflow: hidden;
        position: absolute;
        z-index: 2;
        /* top: 0px; */
        bottom: 55%;
        left: 57%;
    }
    
    
    text {
        fill: #aaa;
    font-family: "Lato", sans-serif;
    font-size: 30px;
    font-weight: 600;
    text-transform: uppercase;
    font-variant-ligatures: none;
    letter-spacing: 6px;
    animation: rotate 25s linear infinite;
    transform-origin: 250px 250px;
    }
    
    svg {
    max-width: 45vmin;
    position: absolute;
    }
    
    @keyframes rotate {
    to {
        transform: rotate(360deg);
    }
    }
    
    .textcircle {
    transition: transform 1s cubic-bezier(0.65, 0, 0.35, 1);
    transform-origin: 250px 250px;
    }
    
    svg:hover .textcircle {
    transform: scale(1.2) rotate(90deg);
    }
</style>
<?php $__env->startSection('content'); ?>

    <?php
        function renderStarRating($rating, $maxRating = 5)
        {
            $fullStar = "<i class = 'far fa-star filled'></i>";
            $halfStar = "<i class = 'far fa-star-half filled'></i>";
            $emptyStar = "<i class = 'far fa-star'></i>";
            $rating = $rating <= $maxRating ? $rating : $maxRating;

            $fullStarCount = (int) $rating;
            $halfStarCount = ceil($rating) - $fullStarCount;
            $emptyStarCount = $maxRating - $fullStarCount - $halfStarCount;

            $html = str_repeat($fullStar, $fullStarCount);
            $html .= str_repeat($halfStar, $halfStarCount);
            $html .= str_repeat($emptyStar, $emptyStarCount);
            $html = $html;
            return $html;
        }
    ?>


    <?php if($setting->is_slider == 1): ?>
        <div class="slider-area-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <!-- Main Slider-->
                        <div class="hero-slider">
                            <div class="hero-slider-main owl-carousel dots-inside" >
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="item
                                    <?php if(DB::table('languages')->where('is_default',1)->first()->rtl == 1): ?>
                                    d-flex justify-content-end
                                    <?php endif; ?>
                                    "
                                        style="background: url('<?php echo e(asset('assets/images/' . $slider->photo)); ?>')">
                                        <div class="item-inner">
                                            <div class="from-bottom">
                                                <?php if($slider->logo): ?>
                                                    <img class="d-inline-block brand-logo"
                                                    src="<?php echo e(asset('assets/images/' . $slider->logo)); ?>"
                                                    alt="logo">
                                                <?php endif; ?>
                                                <div class="title text-body"><?php echo e($slider->title); ?></div>
                                                <div class="subtitle text-body"><?php echo e($slider->details); ?></div>
                                            </div>
                                            <a class="btn btn-primary scale-up delay-1"
                                                href="<?php echo e($slider->link); ?>"> <span><?php echo e(__('Buy Now')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                    <?php if(isset($hero_banner)): ?>
                    <div class="col-lg-4 d-none d-lg-block">
                        <a href="<?php echo e($hero_banner['url1']); ?>" class="sright-image">
                            <img src="<?php echo e(asset('assets/images/'.$hero_banner['img1'])); ?>" alt="">
                            <div class="inner-content">

                                <?php if(isset($hero_banner['subtitle1'])): ?>
                                  <p><?php echo e($hero_banner['subtitle1']); ?></p>
                                <?php endif; ?>

                                <?php if(isset($hero_banner['title1'])): ?>
                                <h4><?php echo e($hero_banner['title1']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                        <div class="rotate-box">
                            <div class="static-img">
                              <img
                                src="https://www.apieu.com/static/img/main/ico_best.png"
                                alt="like-img"
                              />
                            </div>
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              xml:lang="en"
                              xmlns:xlink="http://www.w3.org/1999/xlink"
                              viewBox="0 0 500 500">
                              <defs>
                                <path
                                  id="textcircle"
                                  d="M250,400
                                             a150,150 0 0,1 0,-300a150,150 0 0,1 0,300Z"
                                  transform="rotate(12,250,250)"
                                />
                              </defs>
                              <g class="textcircle">
                                <text textLength="940">
                                  <textPath
                                    xlink:href="#textcircle"
                                    aria-label="CSS & SVG are awesome"
                                    textLength="940"
                                  >
                                  hshabib shop best selling | hshabib shop best selling |&#160;
                                  </textPath>
                                </text>
                              </g>
                            </svg>
                        </div>
                        <a href="<?php echo e($hero_banner['url2']); ?>" class="sright-image mb-0">
                            <img src="<?php echo e(asset('assets/images/'.$hero_banner['img2'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($hero_banner['subtitle2'])): ?>
                                 <p><?php echo e($hero_banner['subtitle2']); ?></p>
                                <?php endif; ?>
                                <?php if(isset($hero_banner['title2'])): ?>
                                 <h4><?php echo e($hero_banner['title2']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                        
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <section class="pre-order-section", style="margin-top: 30px !important;">
        <div class="container">
            <div class="row">
 
                <!-- Modal -->
                <div class="modal fade bd-example-modal-lg" id="createItemModal" tabindex="-1" aria-labelledby="createItemModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <!-- Modal Header -->
                            <div class="modal-header" style="background-color: rgb(60, 99, 238)">
                                <h5 class="modal-title" id="createItemModalLabel">Create Pre Order for New Item</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <!-- Modal Body -->
                            <div class="modal-body">
                                <div class="mb-3">
                                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi dignissim magna sed lorem aliquam, id interdum diam luctus. Cras tristique varius maximus. Vestibulum at placerat ligula. Praesent quis gravida sem. Sed eget dolor vitae tellus sollicitudin ultricies ac sed eros. Nullam scelerisque nisl eu lacus ornare lobortis. Nunc posuere at felis ac hendrerit.</p>
                                </div>
                                <?php if(auth()->guard()->check()): ?>
                                    <form id="itemCreateForm"  action="<?php echo e(route('front.preOrder.submit')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <!-- Item Name -->
                                        <input type="hidden" name="	pre_order_active" value="1">
                                        <div class="row">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('Name')); ?> *</label>
                                                <input type="text" id="name" name="name" class="form-control item-name" placeholder="Enter product name" oninput="generateSlug()">
                                                
                                            </div>
                                            <div class="form-group">
                                                <label for="slug"><?php echo e(__('Slug')); ?> *</label>
                                                <input type="text" id="slug" name="slug" class="form-control" placeholder="Slug will be generated">
                                               
                                            </div>
                                            
                                        </div>
                                    
                                        
                                        <!-- Item Image -->
                                        <div class="form-group">
                                            <label for="name"><?php echo e(__('Set Image')); ?> *</label>
                                            <br>
                                            <img class="admin-img" src="<?php echo e(asset('assets/images/placeholder.png')); ?>"
                                                    alt="No Image Found">
                                            <br>
                                            <span class="mt-1"><?php echo e(__('Image Size Should Be 60 x 60.')); ?></span>
                                        </div>
    
                                        <div class="form-group position-relative">
                                            <label class="file">
                                                <input type="file"  accept="image/*"  class="upload-photo" name="photo" id="file"
                                                    aria-label="File browser example" >
                                                <span class="file-custom text-left"><?php echo e(__('Upload Image...')); ?></span>
                                            </label>
                                        </div>
                                        <!-- Item Description -->
                                        <div class="mb-3">
                                            <label for="item-description" class="form-label">Item Description</label>
                                            <textarea name="description" class="form-control" id="item-description" rows="3"></textarea>
                                        </div>
                                        <div class="row">
                                            <div class="mb-3">
                                                <label for="size" class="form-label">Item Size</label>
                                                <select class="form-control" name="size" id="size">
                                                    <option value="S">S</option>
                                                    <option value="M">M</option>
                                                    <option value="L">L</option>
                                                    <option value="XL">XL</option>
                                                    <option value="XXL">XXL</option>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <div class="mb-3">
                                                    <div class="form-group position-relative">
                                                        <label for="country-search"><?php echo e(__('Country of Origin')); ?></label>
                                                        <!-- Search input field -->
                                                        <input type="text" class="form-control" name="country"  placeholder="<?php echo e(__('Couuntry of Origin')); ?>" autocomplete="off">
                                                        
                                                        <!-- Dropdown menu for suggestions -->
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </form>
                                <?php endif; ?>
                            </div>
                            <!-- Modal Footer -->
                            <div class="modal-footer" style="background-color: #d0cfd2">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" id="createItem" class="btn btn-custom" form="itemCreateForm">Create Item</button>
                            </div>
                        </div>
                    </div>
                </div>
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.3/jquery.validate.min.js"></script>
                <script>
                    function generateSlug() {
                    let name = document.getElementById('name').value;
                    let slug = name
                        .toLowerCase()                       // Convert to lowercase
                        .replace(/[^a-z0-9\s-]/g, '')        // Remove special characters
                        .replace(/\s+/g, '-')                // Replace spaces with hyphens
                        .replace(/-+/g, '-');                // Remove multiple hyphens
                    document.getElementById('slug').value = slug;
                }
                </script>

                <script>
                    document.getElementById('createItem').addEventListener('click', function(event) {
                        event.preventDefault(); // Prevent form submission initially

                        // Check if the user is authenticated
                        <?php if(auth()->guard()->guest()): ?>
                            // If not authenticated, redirect to the login page
                            window.location.href = "<?php echo e(route('user.login')); ?>";
                        <?php endif; ?>

                        <?php if(auth()->guard()->check()): ?>
                            // If authenticated, allow the form to be submitted
                            document.getElementById('itemCreateForm').submit();
                        <?php endif; ?>
                    });
                </script>

            </div>
        </div>
    </section>
        
    <div class="product-item-wrap">
        <?php $__currentLoopData = $frontItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="product-item-outer-wrap">
                <div class="product-item-list">
                <div class="product-item-img">
                    <img src="<?php echo e(asset('assets/images/' . $Item->photo)); ?>" alt="Pre Order">
                </div>
                </div>
                <h6 class="text-center"><b><?php echo e($Item->name); ?></b></h6>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <!-- Repeat for additional items -->
    </div>
    <?php if($setting->is_service == 1): ?>
        <section class="service-section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-sm-6 text-center mb-30" data-bs-toggle="modal" data-bs-target="#createItemModal">
                        <div class="single-service single-service2">
                            <img src="<?php echo e(asset('assets/images/pre-order.png')); ?>" alt="Pre Order">
                            <div class="content">
                                <h6 class="mb-2"> Pre Order </h6>
                                <p class="text-sm text-muted mb-0"> <?php echo e(\Illuminate\Support\Str::limit('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. ', 30, '...')); ?> </p>
                            </div>
                        </div>
                    </div>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-sm-6 text-center mb-30">
                            <div class="single-service single-service2">
                                <img src="<?php echo e(asset('assets/images/' . $service->photo)); ?>" alt="Shipping">
                                <div class="content">
                                    <h6 class="mb-2"><?php echo e($service->title); ?></h6>
                                    <p class="text-sm text-muted mb-0"><?php echo e(\Illuminate\Support\Str::limit($service->details, 30, '...')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($setting->campaign_status == 1): ?>
        <div class="deal-of-day-section mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title">
                            <h2 class="h3"><?php echo e($setting->campaign_title); ?></h2>
                            <div class="right-area">
                                    <div class="countdown countdown-alt" data-date-time="<?php echo e($setting->campaign_end_date); ?>"></div>
                                    <a class="right_link" href="<?php echo e(route('front.campaign')); ?>"><?php echo e(__('View All')); ?> <i class="icon-chevron-right"></i></a>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="row g-3">

                    <div class="col-lg-12">
                    <div class="popular-category-slider owl-carousel">
                        <?php $__currentLoopData = $campaign_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compaign_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="slider-item">
                            <div class="product-card">
                                <div class="product-thumb">
                                    <?php if(!$compaign_item->item->is_stock()): ?>
                                        <div class="product-badge bg-secondary border-default text-body
                                        "><?php echo e(__('out of stock')); ?></div>
                                    <?php endif; ?>

                                    <?php if($compaign_item->item->previous_price && $compaign_item->item->previous_price !=0): ?>
                                        <div class="product-badge product-badge2 bg-info"> -<?php echo e(PriceHelper::DiscountPercentage($compaign_item->item)); ?></div>
                                    <?php endif; ?>
                                    <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$compaign_item->item->thumbnail)); ?>" alt="Product">
                                    <div class="product-button-group"><a class="product-button wishlist_store" href="<?php echo e(route('user.wishlist.store',$compaign_item->item->id)); ?>" title="<?php echo e(__('Wishlist')); ?>"><i class="icon-heart"></i></a>
                                        <a data-target="<?php echo e(route('fornt.compare.product',$compaign_item->item->id)); ?>" class="product-button product_compare" href="javascript:;" title="<?php echo e(__('Compare')); ?>"><i class="icon-repeat"></i></a>
                                        <?php if($compaign_item->item->is_stock()): ?>
                                            <a class="product-button add_to_single_cart"  data-target="<?php echo e($compaign_item->item->id); ?>" href="javascript:;"  title="<?php echo e(__('To Cart')); ?>"><i class="icon-shopping-cart"></i>
                                            </a>
                                        <?php else: ?>
                                            <a class="product-button" href="<?php echo e(route('front.product',$compaign_item->item->slug)); ?>" title="<?php echo e(__('Details')); ?>"><i class="icon-arrow-right"></i></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                    <div class="product-card-body">

                                        <div class="product-category"><a href="<?php echo e(route('front.catalog').'?category='.$compaign_item->item->category->slug); ?>"><?php echo e($compaign_item->item->category->name); ?></a></div>
                                        <h3 class="product-title"><a href="<?php echo e(route('front.product',$compaign_item->item->slug)); ?>">
                                            <?php echo e(strlen(strip_tags($compaign_item->item->name)) > 35 ? substr(strip_tags($compaign_item->item->name), 0, 35) : strip_tags($compaign_item->item->name)); ?>

                                        </a></h3>
                                        <div class="rating-stars">
                                            <?php echo renderStarRating($compaign_item->item->reviews->avg('rating')); ?>

                                        </div>
                                        <h4 class="product-price">
                                        <?php if($compaign_item->item->previous_price != 0): ?>
                                            <del><?php echo e(PriceHelper::setPreviousPrice($compaign_item->item->previous_price)); ?></del>
                                        <?php endif; ?>

                                        <?php echo e(PriceHelper::grandCurrencyPrice($compaign_item->item)); ?>

                                        </h4>

                                    </div>

                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>

                </div>
            </div>
        </div>
    <?php endif; ?>


    <?php if($setting->is_three_c_b_first == 1): ?>
        <div class="bannner-section mt-60">
            <div class="container ">
                <div class="row gx-3">
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_first['firsturl1']); ?>" class="genius-banner">
                            <img src="<?php echo e(asset('assets/images/'.$banner_first['img1'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_first['subtitle1'])): ?>
                                    <p><?php echo e($banner_first['subtitle1']); ?></p>
                                <?php endif; ?>
                                <?php if(isset($banner_first['title1'])): ?>
                                    <h4><?php echo e($banner_first['title1']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_first['firsturl2']); ?>" class="genius-banner">
                            <img src="<?php echo e(asset('assets/images/'.$banner_first['img2'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_first['subtitle2'])): ?>
                                    <p><?php echo e($banner_first['subtitle2']); ?></p>
                                <?php endif; ?>
                                <?php if(isset($banner_first['title2'])): ?>
                                    <h4><?php echo e($banner_first['title2']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_first['firsturl3']); ?>" class="genius-banner">
                            <img src="<?php echo e(asset('assets/images/'.$banner_first['img3'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_first['subtitle3'])): ?>
                                    <p><?php echo e($banner_first['subtitle3']); ?> </p>
                                <?php endif; ?>
                                <?php if(isset($banner_first['title3'])): ?>
                                    <h4><?php echo e($banner_first['title3']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <?php if($setting->is_popular_category == 1): ?>
        <section class="newproduct-section popular-category-sec mt-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title">
                            <h2 class="h3"><?php echo e($popular_category_title); ?></h2>
                            <div class="links">
                                <?php $__currentLoopData = $popular_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $popular_categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="category_get <?php echo e($loop->first ? 'active' : ''); ?>" data-target="popular_category_view" data-href="<?php echo e(route('front.popular.category',[$popular_categorie->slug,'popular_category','slider'])); ?>"  href="javascript:;" class="<?php echo e($loop->first ? 'active' : ''); ?>"><?php echo e($popular_categorie->name); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="popular_category_view d-none">
                    <img  src="<?php echo e(asset('assets/images/ajax_loader.gif')); ?>" alt="">
                </div>

                <div class="row" id="popular_category_view">
                    <div class="col-lg-12">
                        <div class="popular-category-slider  owl-carousel">
                            <?php $__currentLoopData = $popular_category_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popular_category_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="slider-item">
                                <div class="product-card">
                                    <div class="product-thumb">

                                        <?php if(!$popular_category_item->is_stock()): ?>
                                            <div class="product-badge bg-secondary border-default text-body
                                            "><?php echo e(__('out of stock')); ?></div>
                                        <?php endif; ?>
                                        <?php if($popular_category_item->previous_price && $popular_category_item->previous_price !=0): ?>
                                        <div class="product-badge product-badge2 bg-info"> -<?php echo e(PriceHelper::DiscountPercentage($popular_category_item)); ?></div>
                                        <?php endif; ?>
                                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$popular_category_item->thumbnail)); ?>" alt="Product">
                                            <div class="product-button-group">
                                                <a class="product-button wishlist_store" href="<?php echo e(route('user.wishlist.store',$popular_category_item->id)); ?>" title="<?php echo e(__('Wishlist')); ?>"><i class="icon-heart"></i></a>
                                                <a data-target="<?php echo e(route('fornt.compare.product',$popular_category_item->id)); ?>" class="product-button product_compare" href="javascript:;" title="<?php echo e(__('Compare')); ?>"><i class="icon-repeat"></i></a>
                                                <?php echo $__env->make('includes.item_footer',['sitem'=>$popular_category_item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                        </div>
                                    <div class="product-card-body">
                                        <div class="product-category"><a href="<?php echo e(route('front.catalog').'?category='.$popular_category_item->category->slug); ?>"><?php echo e($popular_category_item->category->name); ?></a></div>
                                        <h3 class="product-title"><a href="<?php echo e(route('front.product',$popular_category_item->slug)); ?>">
                                            <?php echo e(strlen(strip_tags($popular_category_item->name)) > 35 ? substr(strip_tags($popular_category_item->name), 0, 35) : strip_tags($popular_category_item->name)); ?>

                                        </a></h3>
                                        <div class="rating-stars">
                                        <i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i>
                                        </div>
                                        <h4 class="product-price">
                                            <?php if($popular_category_item->previous_price != 0): ?>
                                            <del><?php echo e(PriceHelper::setPreviousPrice($popular_category_item->previous_price)); ?></del>
                                            <?php endif; ?>
                                            <?php echo e(PriceHelper::grandCurrencyPrice($popular_category_item)); ?>

                                            </h4>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($setting->is_three_c_b_second == 1): ?>
        <div class="bannner-section mt-60">
            <div class="container ">
                <div class="row gx-3">
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_secend['url1']); ?>" class="genius-banner">
                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$banner_secend['img1'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_secend['subtitle1'])): ?>
                                    <p><?php echo e($banner_secend['subtitle1']); ?></p>
                                <?php endif; ?>

                                <?php if(isset($banner_secend['title1'])): ?>
                                    <h4><?php echo e($banner_secend['title1']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_secend['url2']); ?>" class="genius-banner">
                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$banner_secend['img2'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_secend['subtitle2'])): ?>
                                    <p><?php echo e($banner_secend['subtitle2']); ?></p>
                                <?php endif; ?>

                                <?php if(isset($banner_secend['title2'])): ?>
                                    <h4> <?php echo e($banner_secend['title2']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="<?php echo e($banner_secend['url3']); ?>" class="genius-banner">
                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$banner_secend['img3'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_secend['subtitle3'])): ?>
                                    <p><?php echo e($banner_secend['subtitle3']); ?> </p>
                                <?php endif; ?>

                                <?php if(isset($banner_secend['title3'])): ?>
                                    <h4><?php echo e($banner_secend['title3']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($setting->is_highlighted == 1): ?>
        <section class="selected-product-section speacial-product-sec mt-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title">
                            <div class="links">
                                <a data-href="<?php echo e(route('front.get.product','feature')); ?>" data-target="type_product_view" href="javascript:;" class="product_get active"><?php echo e(__('Featured')); ?></a>
                                <a data-href="<?php echo e(route('front.get.product','best')); ?>" data-target="type_product_view" class="product_get" href="javascript:;"><?php echo e(__('Best Seller')); ?></a>
                                <a data-href="<?php echo e(route('front.get.product','top')); ?>" data-target="type_product_view" class="product_get" href="javascript:;"><?php echo e(__('Top Rated')); ?></a>
                                <a data-href="<?php echo e(route('front.get.product','new')); ?>" data-target="type_product_view" class="product_get" href="javascript:;"><?php echo e(__('New Product')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="type_product_view d-none">
                        <img  src="<?php echo e(asset('assets/images/ajax_loader.gif')); ?>" alt="">
                    </div>
                    <div class="col-lg-12" id="type_product_view">

                        <div class="features-slider  owl-carousel" >
                            <?php $__currentLoopData = $products->orderBy('id','DESC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->is_type == 'feature'): ?>
                                    <div class="slider-item">
                                        <div class="product-card ">
                                            <div class="product-thumb">
                                                <?php if(!$item->is_stock()): ?>
                                                    <div class="product-badge bg-secondary border-default text-body
                                                    "><?php echo e(__('out of stock')); ?></div>
                                                <?php endif; ?>
                                                <?php if($item->previous_price && $item->previous_price !=0): ?>
                                                <div class="product-badge product-badge2 bg-info"> -<?php echo e(PriceHelper::DiscountPercentage($item)); ?></div>
                                                <?php endif; ?>
                                                <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$item->thumbnail)); ?>" alt="Product">
                                                <div class="product-button-group"><a class="product-button wishlist_store" href="<?php echo e(route('user.wishlist.store',$item->id)); ?>" title="<?php echo e(__('Wishlist')); ?>"><i class="icon-heart"></i></a>
                                                    <a data-target="<?php echo e(route('fornt.compare.product',$item->id)); ?>" class="product-button product_compare" href="javascript:;" title="<?php echo e(__('Compare')); ?>"><i class="icon-repeat"></i></a>
                                                    <?php echo $__env->make('includes.item_footer',['sitem' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>
                                            </div>
                                            <div class="product-card-inner">
                                            <div class="product-card-body">
                                                <div class="product-category"><a href="<?php echo e(route('front.catalog').'?category='.$item->category->slug); ?>"><?php echo e($item->category->name); ?></a></div>
                                                <h3 class="product-title"><a href="<?php echo e(route('front.product',$item->slug)); ?>">
                                                    <?php echo e(strlen(strip_tags($item->name)) > 35 ? substr(strip_tags($item->name), 0, 35) : strip_tags($item->name)); ?>

                                                </a></h3>
                                                <div class="rating-stars">
                                                    <?php echo renderStarRating($item->reviews->avg('rating')); ?>

                                                </div>
                                                <h4 class="product-price">
                                                <?php if($item->previous_price != 0): ?>
                                                <del><?php echo e(PriceHelper::setPreviousPrice($item->previous_price)); ?></del>
                                                <?php endif; ?>
                                                <?php echo e(PriceHelper::grandCurrencyPrice($item)); ?>

                                                </h4>
                                            </div>

                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($extra_settings->is_t1_falsh == 1): ?>
    <div class="flash-sell-new-section mt-50">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 ">
                    <div class="section-title">
                        <h2 class="h3"><?php echo e(__('Flash Deal')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="main-content">
                        <div class="flash-deal-slider owl-carousel" >
                            <?php $__currentLoopData = $products->orderBy('id','DESC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->is_type == 'flash_deal' && $item->date != null): ?>
                                <div class="slider-item">
                                    <div class="product-card ">
                                        <div class="product-thumb">
                                            <?php if(!$item->is_stock()): ?>
                                            <div class="product-badge bg-secondary border-default text-body
                                            "><?php echo e(__('out of stock')); ?></div>
                                            <?php endif; ?>
                                            <?php if($item->previous_price && $item->previous_price !=0): ?>
                                            <div class="product-badge product-badge2 bg-info"> -<?php echo e(PriceHelper::DiscountPercentage($item)); ?></div>
                                            <?php endif; ?>
                                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$item->thumbnail)); ?>" alt="Product">
                                            <div class="product-button-group"><a class="product-button wishlist_store" href="<?php echo e(route('user.wishlist.store',$item->id)); ?>" title="<?php echo e(__('Wishlist')); ?>"><i class="icon-heart"></i></a>
                                                <a data-target="<?php echo e(route('fornt.compare.product',$item->id)); ?>" class="product-button product_compare" href="javascript:;" title="<?php echo e(__('Compare')); ?>"><i class="icon-repeat"></i></a>
                                                <?php echo $__env->make('includes.item_footer',['sitem' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                        </div>
                                        <div class="product-card-inner">
                                            <div class="product-card-body">

                                                <div class="product-category"><a href="<?php echo e(route('front.catalog').'?category='.$item->category->slug); ?>"><?php echo e($item->category->name); ?></a></div>
                                                <h3 class="product-title"><a href="<?php echo e(route('front.product',$item->slug)); ?>">
                                                    <?php echo e(strlen(strip_tags($item->name)) > 50 ? substr(strip_tags($item->name), 0, 50) : strip_tags($item->name)); ?>

                                                </a></h3>
                                                <div class="rating-stars">
                                                    <?php echo renderStarRating($item->reviews->avg('rating')); ?>

                                                </div>
                                                <h4 class="product-price">
                                                <?php if($item->previous_price != 0): ?>
                                                <del><?php echo e(PriceHelper::setPreviousPrice($item->previous_price)); ?></del>
                                                <?php endif; ?>

                                                <?php echo e(PriceHelper::grandCurrencyPrice($item)); ?>

                                                </h4>
                                                <?php if(date('d-m-y') != \Carbon\Carbon::parse($item->date)->format('d-m-y')): ?>
                                                <div class="countdown countdown-alt mb-3" data-date-time="<?php echo e($item->date); ?>">
                                                </div>
                                                <?php endif; ?>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if($setting->is_two_column_category == 1): ?>
        <div class="flash-sell-area mt-50">
            <div class="container">
                <div class="row gx-3 justify-content-center">
                    <?php $__currentLoopData = $two_column_categoriess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $two_column_key => $two_column_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6">
                        <div class="section-title">
                            <h2 class="h3"><?php echo e($two_column_category['name']->name); ?></h2>
                        </div>
                        <div class="main-content">
                            <div class="newproduct-slider owl-carousel">
                                <?php $__currentLoopData = $two_column_categoriess[$two_column_key]['items']->chunk(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $two_column_category_itemt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="slider-item">
                                        <?php $__currentLoopData = $two_column_category_itemt; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $two_column_category_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="product-card p-col">
                                            <a class="product-thumb" href="<?php echo e(route('front.product',$two_column_category_item->slug)); ?>">
                                                <?php if(!$two_column_category_item->is_stock()): ?>
                                                    <div class="product-badge bg-secondary border-default text-body
                                                    "><?php echo e(__('out of stock')); ?></div>
                                                    <?php endif; ?>

                                                <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$two_column_category_item->thumbnail)); ?>" alt="Product"></a>
                                            <div class="product-card-body">
                                                <h3 class="product-title"><a href="<?php echo e(route('front.product',$two_column_category_item->slug)); ?>">
                                                    <?php echo e(strlen(strip_tags($two_column_category_item->name)) > 40 ? substr(strip_tags($two_column_category_item->name), 0, 40) : strip_tags($two_column_category_item->name)); ?>

                                                </a></h3>
                                                <div class="rating-stars">
                                                    <?php echo renderStarRating($two_column_category_item->reviews->avg('rating')); ?>

                                                </div>
                                                <h4 class="product-price">
                                                <?php if($two_column_category_item->previous_price != 0): ?>
                                                <del><?php echo e(PriceHelper::setPreviousPrice($two_column_category_item->previous_price)); ?></del>
                                                <?php endif; ?>
                                                    <?php echo e(PriceHelper::grandCurrencyPrice($two_column_category_item)); ?>

                                                </h4>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($setting->is_two_c_b == 1): ?>
        <div class="bannner-section mt-50">
            <div class="container ">
                <div class="row gx-3">
                    <div class="col-md-6">
                        <a href="<?php echo e($banner_third['url1']); ?>" class="genius-banner">
                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$banner_third['img1'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_third['subtitle1'])): ?>
                                    <p><?php echo e($banner_third['subtitle1']); ?></p>
                                <?php endif; ?>
                                <?php if(isset($banner_third['title1'])): ?>
                                    <h4><?php echo e($banner_third['title1']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="<?php echo e($banner_third['url2']); ?>" class="genius-banner">
                            <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$banner_third['img2'])); ?>" alt="">
                            <div class="inner-content">
                                <?php if(isset($banner_third['subtitle2'])): ?>
                                    <p><?php echo e($banner_third['subtitle2']); ?> </p>
                                <?php endif; ?>
                                <?php if(isset($banner_third['title2'])): ?>
                                    <h4><?php echo e($banner_third['title2']); ?></h4>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($setting->is_featured_category == 1): ?>
        <section class="selected-product-section featured_cat_sec sps-two mt-50">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title">
                            <h2 class="h3"><?php echo e($feature_category_title); ?></h2>
                            <div class="links">
                                <?php $__currentLoopData = $feature_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $feature_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="category_get <?php echo e($loop->first ? 'active' : ''); ?>" data-target="feature_category_view"  data-href="<?php echo e(route('front.popular.category',[$feature_category->slug,'feature_category','normal'])); ?>" href="javascript:;" class="<?php echo e($loop->first ? 'active' : ''); ?>"><?php echo e($feature_category->name); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="feature_category_view d-none">
                    <img  src="<?php echo e(asset('assets/images/ajax_loader.gif')); ?>" alt="">
                </div>
                <div class="row g-3" id="feature_category_view">
                    <?php $__currentLoopData = $feature_category_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature_category_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-gd">
                        <div class="product-card">
                            <div class="product-thumb" >

                                <?php if(!$feature_category_item->is_stock()): ?>
                                    <div class="product-badge bg-secondary border-default text-body
                                    "><?php echo e(__('out of stock')); ?></div>
                                <?php endif; ?>
                                <?php if($feature_category_item->previous_price && $feature_category_item->previous_price !=0): ?>
                                <div class="product-badge product-badge2 bg-info"> -<?php echo e(PriceHelper::DiscountPercentage($feature_category_item)); ?></div>
                                <?php endif; ?>
                                    <img class="lazy" data-src="<?php echo e(asset('assets/images/'.$feature_category_item->thumbnail)); ?>" alt="Product">
                                    <div class="product-button-group"><a class="product-button wishlist_store" href="<?php echo e(route('user.wishlist.store',$feature_category_item->id)); ?>" title="<?php echo e(__('Wishlist')); ?>"><i class="icon-heart"></i></a>
                                        <a data-target="<?php echo e(route('fornt.compare.product',$feature_category_item->id)); ?>" class="product-button product_compare" href="javascript:;" title="<?php echo e(__('Compare')); ?>"><i class="icon-repeat"></i></a>

                                        <?php echo $__env->make('includes.item_footer',['sitem'=>$feature_category_item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    </div>
                            </div>
                            <div class="product-card-body">
                                <div class="product-category"><a href="<?php echo e(route('front.catalog').'?category='.$feature_category_item->category->slug); ?>"><?php echo e($feature_category_item->category->name); ?></a></div>
                                <h3 class="product-title"><a href="<?php echo e(route('front.product',$feature_category_item->slug)); ?>">
                                    <?php echo e(strlen(strip_tags($feature_category_item->name)) > 35 ? substr(strip_tags($feature_category_item->name), 0, 35) : strip_tags($feature_category_item->name)); ?>

                                </a></h3>
                                <div class="rating-stars">
                                <i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i><i class="far fa-star filled"></i>
                                </div>
                                <h4 class="product-price">
                                    <?php if($feature_category_item->previous_price != 0): ?>
                                    <del><?php echo e(PriceHelper::setPreviousPrice($feature_category_item->previous_price)); ?></del>
                                    <?php endif; ?>
                                    <?php echo e(PriceHelper::grandCurrencyPrice($feature_category_item)); ?>

                                    </h4>
                            </div>

                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($setting->is_blogs == 1): ?>
        <div class="blog-section-h page_section mt-50 mb-30">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title">
                            <h2 class="h3"><?php echo e(__('Our Blog')); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="home-blog-slider owl-carousel">
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="slider-item">
                                    <a href="<?php echo e(route('front.blog.details',$post->slug)); ?>" class="blog-post">
                                        <div class="post-thumb">
                                            <img class="lazy" data-src="<?php echo e(asset('assets/images/' . json_decode($post->photo, true)[array_key_first(json_decode($post->photo, true))])); ?>"
                                                alt="Blog Post">
                                            </div>
                                        <div class="post-body">

                                            <h3 class="post-title"> <?php echo e(strlen(strip_tags($post->title)) > 55 ? substr(strip_tags($post->title), 0, 55) : strip_tags($post->title)); ?>

                                            </h3>
                                            <ul class="post-meta">

                                                <li><i class="icon-user"></i><?php echo e(__('Admin')); ?></li>
                                                <li><i class="icon-clock"></i><?php echo e(date('jS F, Y', strtotime($post->created_at))); ?></li>
                                            </ul>
                                            <p><?php echo e(strlen(strip_tags($post->details)) > 120 ? substr(strip_tags($post->details), 0, 120) : strip_tags($post->details)); ?>

                                            </p>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($setting->is_popular_brand == 1): ?>
    <section class="brand-section mt-30 mb-60">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title">
                        <h2 class="h3"><?php echo e(__('Popular Brands')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div id="brandCarousel" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner">
                            <!-- Group brands in chunks of 6 per carousel item -->
                            <?php $__currentLoopData = $brands->chunk(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-item <?php echo e($loop->first ? 'active' : ''); ?>">
                                <div class="row">
                                    <?php $__currentLoopData = $brandChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-2">
                                        <div class="brand-card text-center">
                                            <div class="brand-image">
                                                <a href="<?php echo e(route('front.catalog', ['brand' => $brand->slug])); ?>">
                                                    <img class="img-fluid lazy"
                                                         data-src="<?php echo e(asset('assets/images/' . $brand->photo)); ?>"
                                                         alt="<?php echo e($brand->name); ?>" title="<?php echo e($brand->name); ?>">
                                                </a>
                                            </div>
                                            <div class="brand-name">
                                                <h6><?php echo e($brand->name); ?></h6>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
    
                        <!-- Carousel controls -->
                        <a class="carousel-control-prev" href="#brandCarousel" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#brandCarousel" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>



<div id="map" style="width: 100%; height: 400px;"></div>
<style>
    .brand-card {
        background-color: #f8f9fa;
        border-radius: 8px;
        box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        padding: 10px;
        width: 140px; /* Set a fixed width for each card */
        height: 180px; /* Set a fixed height for each card */
        margin: 10px auto; /* Center the cards */
    }

    .brand-image img {
        width: 120px; /* Fixed width for image */
        height: 100px; /* Fixed height for image */
        object-fit: cover; /* Crop image to fit the set dimensions */
        border-radius: 6px;
    }

    .brand-name h6 {
        margin-top: 10px;
        font-size: 0.9rem;
        color: #333;
    }

</style>
<style>
    .product-item-wrap {
        display: flex !important;
        flex-wrap: wrap;
        justify-content: center; 
    }
    .product-item-list {
        width: 100px;
        height: 100px;
        background: linear-gradient(
            to bottom right,
            #7ebdff 20%,
            #6da8e7 40%,
            #236dbd 60%,
            #005cb2 80%,
            #003399
        ) !important;
        margin: 0 20px !important;
        border-radius: 50% !important; 
        /* overflow: hidden; */
        display: flex; 
        align-items: center; 
        justify-content: center;
    }
    
</style>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBeiRykv80iXpCJNa1kmHQYp-ow6NP7Zcw&callback=initMap" async defer></script>
<script>
    function initMap() {
        var location = {lat: 23.8103, lng: 90.4125}; // Coordinates for Dhaka
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 15,
            center: location
        });

        var marker = new google.maps.Marker({
            position: location,
            map: map,
            title: 'Your Location'
        });
    }
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const lazyImages = document.querySelectorAll(".lazy");
        lazyImages.forEach(img => {
            img.src = img.dataset.src;
            img.classList.remove("lazy");
        });
    });
</script>
<script type="text/javascript" src=
"https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script type="text/javascript"
        src=
"https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js"></script>
    <script type="text/javascript"
        src=
"https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js"></script>


<style>
    .rotate-box {
        display: grid;
        place-items: center;
        height: 200px;
        width: 200px;
        overflow: hidden;
        position: absolute;
        z-index: 2;
        /* top: 0px; */
        bottom: 61%;
        left: 58%;
    }
    
    
    text {
        fill: #aaa;
    font-family: "Lato", sans-serif;
    font-size: 30px;
    font-weight: 600;
    text-transform: uppercase;
    font-variant-ligatures: none;
    letter-spacing: 6px;
    animation: rotate 25s linear infinite;
    transform-origin: 250px 250px;
    }
    
    svg {
    max-width: 45vmin;
    position: absolute;
    }
    
    @keyframes rotate {
    to {
        transform: rotate(360deg);
    }
    }
    
    .textcircle {
    transition: transform 1s cubic-bezier(0.65, 0, 0.35, 1);
    transform-origin: 250px 250px;
    }
    
    svg:hover .textcircle {
    transform: scale(1.2) rotate(90deg);
    }

    .col-lg-4.col-sm-6.text-center.mb-30 {
        height: 200px;
        /* background: #6da8e7; */
        padding: 1%
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\shhabib\core\resources\views/front/themes/theme1.blade.php ENDPATH**/ ?>